
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderChange.rq;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Associations to Offers and Offer Items, including the corresponding Shopping Response ID.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/2015/00/2019.1/IATA_OrderChangeRQ" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OfferAssociationType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="OfferItemRefID" minOccurs="0" maxOccurs="unbounded"/>
 *     &lt;xs:element type="xs:string" name="OfferRefID" minOccurs="1" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="OwnerCode" minOccurs="1" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="ShoppingResponseRefID" minOccurs="0" maxOccurs="1"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class OfferAssociationType implements Serializable
{
    private List<String> offerItemRefIDList = new ArrayList<String>();
    private String offerRefID;
    private String ownerCode;
    private String shoppingResponseRefID;

    /** 
     * Get the list of 'OfferItemRefID' element items. Reference to an Offer Item ID for which this Payment applies.
     * 
     * @return list
     */
    public List<String> getOfferItemRefIDList() {
        return offerItemRefIDList;
    }

    /** 
     * Set the list of 'OfferItemRefID' element items. Reference to an Offer Item ID for which this Payment applies.
     * 
     * @param list
     */
    public void setOfferItemRefIDList(List<String> list) {
        offerItemRefIDList = list;
    }

    /** 
     * Get the 'OfferRefID' element value. Reference to an Offer ID for which this Payment applies.
     * 
     * @return value
     */
    public String getOfferRefID() {
        return offerRefID;
    }

    /** 
     * Set the 'OfferRefID' element value. Reference to an Offer ID for which this Payment applies.
     * 
     * @param offerRefID
     */
    public void setOfferRefID(String offerRefID) {
        this.offerRefID = offerRefID;
    }

    /** 
     * Get the 'OwnerCode' element value. Airline code assigned to a carrier. Either ICAO-defined 3-character code or IATA-defined 2-character code.
     * 
     * @return value
     */
    public String getOwnerCode() {
        return ownerCode;
    }

    /** 
     * Set the 'OwnerCode' element value. Airline code assigned to a carrier. Either ICAO-defined 3-character code or IATA-defined 2-character code.
     * 
     * @param ownerCode
     */
    public void setOwnerCode(String ownerCode) {
        this.ownerCode = ownerCode;
    }

    /** 
     * Get the 'ShoppingResponseRefID' element value. Reference to unique shopping session response ID, as provided in the airline's previous shopping response.
     * 
     * @return value
     */
    public String getShoppingResponseRefID() {
        return shoppingResponseRefID;
    }

    /** 
     * Set the 'ShoppingResponseRefID' element value. Reference to unique shopping session response ID, as provided in the airline's previous shopping response.
     * 
     * @param shoppingResponseRefID
     */
    public void setShoppingResponseRefID(String shoppingResponseRefID) {
        this.shoppingResponseRefID = shoppingResponseRefID;
    }
}
