
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderChange.rq;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Special service information
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/2015/00/2019.1/IATA_OrderChangeRQ" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OrderInstructionType">
 *   &lt;xs:choice>
 *     &lt;xs:element type="ns:CabinTypeType" name="CabinTypeUpgrade" minOccurs="1" maxOccurs="unbounded"/>
 *     &lt;xs:element type="ns:CommissionType" name="Commission" minOccurs="1" maxOccurs="1"/>
 *     &lt;xs:element type="ns:SpecialServiceType" name="SpecialService" minOccurs="1" maxOccurs="unbounded"/>
 *   &lt;/xs:choice>
 * &lt;/xs:complexType>
 * </pre>
 */
public class OrderInstructionType implements Serializable
{
    private int choiceSelect = -1;
    private static final int CABIN_TYPE_UPGRADE_LIST_CHOICE = 0;
    private static final int COMMISSION_CHOICE = 1;
    private static final int SPECIAL_SERVICE_LIST_CHOICE = 2;
    private List<CabinTypeType> cabinTypeUpgradeList = new ArrayList<CabinTypeType>();
    private CommissionType commission;
    private List<SpecialServiceType> specialServiceList = new ArrayList<SpecialServiceType>();

    private void setChoiceSelect(int choice) {
        if (choiceSelect == -1) {
            choiceSelect = choice;
        } else if (choiceSelect != choice) {
            throw new IllegalStateException(
                    "Need to call clearChoiceSelect() before changing existing choice");
        }
    }

    /** 
     * Clear the choice selection.
     */
    public void clearChoiceSelect() {
        choiceSelect = -1;
    }

    /** 
     * Check if CabinTypeUpgradeList is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifCabinTypeUpgradeList() {
        return choiceSelect == CABIN_TYPE_UPGRADE_LIST_CHOICE;
    }

    /** 
     * Get the list of 'CabinTypeUpgrade' element items. Upgrade-eligible class(es) of service.
     * 
     * @return list
     */
    public List<CabinTypeType> getCabinTypeUpgradeList() {
        return cabinTypeUpgradeList;
    }

    /** 
     * Set the list of 'CabinTypeUpgrade' element items. Upgrade-eligible class(es) of service.
     * 
     * @param list
     */
    public void setCabinTypeUpgradeList(List<CabinTypeType> list) {
        setChoiceSelect(CABIN_TYPE_UPGRADE_LIST_CHOICE);
        cabinTypeUpgradeList = list;
    }

    /** 
     * Check if Commission is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifCommission() {
        return choiceSelect == COMMISSION_CHOICE;
    }

    /** 
     * Get the 'Commission' element value. An amount of money, typically a set percentage of the value involved, paid to an agent in a commercial transaction.
     * 
     * @return value
     */
    public CommissionType getCommission() {
        return commission;
    }

    /** 
     * Set the 'Commission' element value. An amount of money, typically a set percentage of the value involved, paid to an agent in a commercial transaction.
     * 
     * @param commission
     */
    public void setCommission(CommissionType commission) {
        setChoiceSelect(COMMISSION_CHOICE);
        this.commission = commission;
    }

    /** 
     * Check if SpecialServiceList is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifSpecialServiceList() {
        return choiceSelect == SPECIAL_SERVICE_LIST_CHOICE;
    }

    /** 
     * Get the list of 'SpecialService' element items. Special service information
     * 
     * @return list
     */
    public List<SpecialServiceType> getSpecialServiceList() {
        return specialServiceList;
    }

    /** 
     * Set the list of 'SpecialService' element items. Special service information
     * 
     * @param list
     */
    public void setSpecialServiceList(List<SpecialServiceType> list) {
        setChoiceSelect(SPECIAL_SERVICE_LIST_CHOICE);
        specialServiceList = list;
    }
}
