
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderChange.rq;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * The Origin and Destination airport/city pair which confines a passenger journey or an aircraft flight.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/2015/00/2019.1/IATA_OrderChangeRQ" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OriginDestType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="DestCode" minOccurs="1" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="OriginCode" minOccurs="1" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="OriginDestID" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="PaxJourneyRefID" minOccurs="0" maxOccurs="unbounded"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class OriginDestType implements Serializable
{
    private String destCode;
    private String originCode;
    private String originDestID;
    private List<String> paxJourneyRefIDList = new ArrayList<String>();

    /** 
     * Get the 'DestCode' element value. IATA defined code identifying a city or station.
     * 
     * @return value
     */
    public String getDestCode() {
        return destCode;
    }

    /** 
     * Set the 'DestCode' element value. IATA defined code identifying a city or station.
     * 
     * @param destCode
     */
    public void setDestCode(String destCode) {
        this.destCode = destCode;
    }

    /** 
     * Get the 'OriginCode' element value. IATA defined code identifying a city or station.
     * 
     * @return value
     */
    public String getOriginCode() {
        return originCode;
    }

    /** 
     * Set the 'OriginCode' element value. IATA defined code identifying a city or station.
     * 
     * @param originCode
     */
    public void setOriginCode(String originCode) {
        this.originCode = originCode;
    }

    /** 
     * Get the 'OriginDestID' element value. Uniquely identifies an Origin Destination within the context of one message.
     * 
     * @return value
     */
    public String getOriginDestID() {
        return originDestID;
    }

    /** 
     * Set the 'OriginDestID' element value. Uniquely identifies an Origin Destination within the context of one message.
     * 
     * @param originDestID
     */
    public void setOriginDestID(String originDestID) {
        this.originDestID = originDestID;
    }

    /** 
     * Get the list of 'PaxJourneyRefID' element items. Uniquely identifies a Passenger Journey within the context of one message.
     * 
     * @return list
     */
    public List<String> getPaxJourneyRefIDList() {
        return paxJourneyRefIDList;
    }

    /** 
     * Set the list of 'PaxJourneyRefID' element items. Uniquely identifies a Passenger Journey within the context of one message.
     * 
     * @param list
     */
    public void setPaxJourneyRefIDList(List<String> list) {
        paxJourneyRefIDList = list;
    }
}
