
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderChange.rq;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Passenger data list definition.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/2015/00/2019.1/IATA_OrderChangeRQ" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PaxListType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:PaxType" name="Pax" minOccurs="1" maxOccurs="unbounded"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class PaxListType implements Serializable
{
    private List<PaxType> paxList = new ArrayList<PaxType>();

    /** 
     * Get the list of 'Pax' element items. Any person except members of the crew carried or to be carried with the consent of the carrier, on board of any transport vehicle such as aircraft, train, bus, ship. Holds the attributes specific to a one booking, from shopping to fulfillment.
     * 
     * @return list
     */
    public List<PaxType> getPaxList() {
        return paxList;
    }

    /** 
     * Set the list of 'Pax' element items. Any person except members of the crew carried or to be carried with the consent of the carrier, on board of any transport vehicle such as aircraft, train, bus, ship. Holds the attributes specific to a one booking, from shopping to fulfillment.
     * 
     * @param list
     */
    public void setPaxList(List<PaxType> list) {
        paxList = list;
    }
}
