
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderChange.rq;

import java.io.Serializable;

/** 
 * A telephone number is a sequence of digits assigned to a fixed-line telephone subscriber station connected to a telephone line or to a wireless electronic telephony device, such as a radio telephone or a mobile telephone, or to other devices for data transmission via the public switched telephone network (PSTN) or other private networks.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/2015/00/2019.1/IATA_OrderChangeRQ" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PhoneType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="AreaCodeNumber" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="CountryDialingCode" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="ExtensionNumber" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="LabelText" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="PhoneNumber" minOccurs="0" maxOccurs="1"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class PhoneType implements Serializable
{
    private String areaCodeNumber;
    private String countryDialingCode;
    private String extensionNumber;
    private String labelText;
    private String phoneNumber;

    /** 
     * Get the 'AreaCodeNumber' element value. Phone number area code.  Example: 813 Note: The phone number can be put unstructured into the phone element or can be put structured into country dialing code, area code, phone number and extension.
     * 
     * @return value
     */
    public String getAreaCodeNumber() {
        return areaCodeNumber;
    }

    /** 
     * Set the 'AreaCodeNumber' element value. Phone number area code.  Example: 813 Note: The phone number can be put unstructured into the phone element or can be put structured into country dialing code, area code, phone number and extension.
     * 
     * @param areaCodeNumber
     */
    public void setAreaCodeNumber(String areaCodeNumber) {
        this.areaCodeNumber = areaCodeNumber;
    }

    /** 
     * Get the 'CountryDialingCode' element value. Numeric telephone dialingÂ prefixes for the memberÂ countries of the International Telecommunication Union (ITU). Note: The phone number can be put unstructured into the phone element or can be put structured into country dialing code, area code, phone number and extension.
     * 
     * @return value
     */
    public String getCountryDialingCode() {
        return countryDialingCode;
    }

    /** 
     * Set the 'CountryDialingCode' element value. Numeric telephone dialingÂ prefixes for the memberÂ countries of the International Telecommunication Union (ITU). Note: The phone number can be put unstructured into the phone element or can be put structured into country dialing code, area code, phone number and extension.
     * 
     * @param countryDialingCode
     */
    public void setCountryDialingCode(String countryDialingCode) {
        this.countryDialingCode = countryDialingCode;
    }

    /** 
     * Get the 'ExtensionNumber' element value. Phone extension number.  Example: 1234 Note: The phone number can be put unstructured into the phone element or can be put structured into country dialing code, area code, phone number and extension.
     * 
     * @return value
     */
    public String getExtensionNumber() {
        return extensionNumber;
    }

    /** 
     * Set the 'ExtensionNumber' element value. Phone extension number.  Example: 1234 Note: The phone number can be put unstructured into the phone element or can be put structured into country dialing code, area code, phone number and extension.
     * 
     * @param extensionNumber
     */
    public void setExtensionNumber(String extensionNumber) {
        this.extensionNumber = extensionNumber;
    }

    /** 
     * Get the 'LabelText' element value. Used to differentiate multiple Phone numbers of one contact.  Examples: Work, Home, Mobile
     * 
     * @return value
     */
    public String getLabelText() {
        return labelText;
    }

    /** 
     * Set the 'LabelText' element value. Used to differentiate multiple Phone numbers of one contact.  Examples: Work, Home, Mobile
     * 
     * @param labelText
     */
    public void setLabelText(String labelText) {
        this.labelText = labelText;
    }

    /** 
     * Get the 'PhoneNumber' element value. Phone number text. Examples: +1 999-999-9999 ext 1234,  617-9976 Note: This may be a simple, un-structured phone number, such as +01 999-999-9999 ext 1234 or combined with additional attributes country dialing code, area code and extension to create a structured phone number.
     * 
     * @return value
     */
    public String getPhoneNumber() {
        return phoneNumber;
    }

    /** 
     * Set the 'PhoneNumber' element value. Phone number text. Examples: +1 999-999-9999 ext 1234,  617-9976 Note: This may be a simple, un-structured phone number, such as +01 999-999-9999 ext 1234 or combined with additional attributes country dialing code, area code and extension to create a structured phone number.
     * 
     * @param phoneNumber
     */
    public void setPhoneNumber(String phoneNumber) {
        this.phoneNumber = phoneNumber;
    }
}
