
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderChange.rq;

import java.io.Serializable;

/** 
 * A personâ€™s case of being registered with a countryâ€™s redress program, which can eliminate watch list misidentification and assist in identity verification.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/2015/00/2019.1/IATA_OrderChangeRQ" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="RedressCaseType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:CountryType" name="Country" minOccurs="1" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="CountryCode" minOccurs="1" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="ProgramName" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="RedressCaseID" minOccurs="1" maxOccurs="1"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class RedressCaseType implements Serializable
{
    private CountryType country;
    private String countryCode;
    private String programName;
    private String redressCaseID;

    /** 
     * Get the 'Country' element value. A nation with its own government, occupying a particular territory.
     * 
     * @return value
     */
    public CountryType getCountry() {
        return country;
    }

    /** 
     * Set the 'Country' element value. A nation with its own government, occupying a particular territory.
     * 
     * @param country
     */
    public void setCountry(CountryType country) {
        this.country = country;
    }

    /** 
     * Get the 'CountryCode' element value. ISO Country Code (can be extended by bilateral agreement in case of exceptions, e.g. Kosovo). Examples: US, FR.
     * 
     * @return value
     */
    public String getCountryCode() {
        return countryCode;
    }

    /** 
     * Set the 'CountryCode' element value. ISO Country Code (can be extended by bilateral agreement in case of exceptions, e.g. Kosovo). Examples: US, FR.
     * 
     * @param countryCode
     */
    public void setCountryCode(String countryCode) {
        this.countryCode = countryCode;
    }

    /** 
     * Get the 'ProgramName' element value. The name of the redress program (e.g. Secure Flight Program).
     * 
     * @return value
     */
    public String getProgramName() {
        return programName;
    }

    /** 
     * Set the 'ProgramName' element value. The name of the redress program (e.g. Secure Flight Program).
     * 
     * @param programName
     */
    public void setProgramName(String programName) {
        this.programName = programName;
    }

    /** 
     * Get the 'RedressCaseID' element value. A unique government-issued identifier assigned to a redress case.
     * 
     * @return value
     */
    public String getRedressCaseID() {
        return redressCaseID;
    }

    /** 
     * Set the 'RedressCaseID' element value. A unique government-issued identifier assigned to a redress case.
     * 
     * @param redressCaseID
     */
    public void setRedressCaseID(String redressCaseID) {
        this.redressCaseID = redressCaseID;
    }
}
