
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderChange.rq;

import java.io.Serializable;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;

/** 
 * Seat service information used for long sells.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/2015/00/2019.1/IATA_OrderChangeRQ" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="SeatItemType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="ColumnID" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="DatedOperatingLegRefID" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="PaxSegmentRefID" minOccurs="1" maxOccurs="1"/>
 *     &lt;xs:element type="ns:PriceType" name="Price" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:integer" name="RowNumber" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="SeatProfileRefID" minOccurs="0" maxOccurs="unbounded"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class SeatItemType implements Serializable
{
    private String columnID;
    private String datedOperatingLegRefID;
    private String paxSegmentRefID;
    private PriceType price;
    private BigInteger rowNumber;
    private List<String> seatProfileRefIDList = new ArrayList<String>();

    /** 
     * Get the 'ColumnID' element value. Alphabetic character identifying a seat within a row.
     * 
     * @return value
     */
    public String getColumnID() {
        return columnID;
    }

    /** 
     * Set the 'ColumnID' element value. Alphabetic character identifying a seat within a row.
     * 
     * @param columnID
     */
    public void setColumnID(String columnID) {
        this.columnID = columnID;
    }

    /** 
     * Get the 'DatedOperatingLegRefID' element value. Reference to a Dated Operating Leg within this message.
     * 
     * @return value
     */
    public String getDatedOperatingLegRefID() {
        return datedOperatingLegRefID;
    }

    /** 
     * Set the 'DatedOperatingLegRefID' element value. Reference to a Dated Operating Leg within this message.
     * 
     * @param datedOperatingLegRefID
     */
    public void setDatedOperatingLegRefID(String datedOperatingLegRefID) {
        this.datedOperatingLegRefID = datedOperatingLegRefID;
    }

    /** 
     * Get the 'PaxSegmentRefID' element value. Reference to a Passenger Segment within this message.
     * 
     * @return value
     */
    public String getPaxSegmentRefID() {
        return paxSegmentRefID;
    }

    /** 
     * Set the 'PaxSegmentRefID' element value. Reference to a Passenger Segment within this message.
     * 
     * @param paxSegmentRefID
     */
    public void setPaxSegmentRefID(String paxSegmentRefID) {
        this.paxSegmentRefID = paxSegmentRefID;
    }

    /** 
     * Get the 'Price' element value. The amount of money expected, required, or given in payment for something.
     * 
     * @return value
     */
    public PriceType getPrice() {
        return price;
    }

    /** 
     * Set the 'Price' element value. The amount of money expected, required, or given in payment for something.
     * 
     * @param price
     */
    public void setPrice(PriceType price) {
        this.price = price;
    }

    /** 
     * Get the 'RowNumber' element value. Ordinal number identifying a seat row in an aircraft.
     * 
     * @return value
     */
    public BigInteger getRowNumber() {
        return rowNumber;
    }

    /** 
     * Set the 'RowNumber' element value. Ordinal number identifying a seat row in an aircraft.
     * 
     * @param rowNumber
     */
    public void setRowNumber(BigInteger rowNumber) {
        this.rowNumber = rowNumber;
    }

    /** 
     * Get the list of 'SeatProfileRefID' element items. Reference to a Seat Profile definition within this message.
     * 
     * @return list
     */
    public List<String> getSeatProfileRefIDList() {
        return seatProfileRefIDList;
    }

    /** 
     * Set the list of 'SeatProfileRefID' element items. Reference to a Seat Profile definition within this message.
     * 
     * @param list
     */
    public void setSeatProfileRefIDList(List<String> list) {
        seatProfileRefIDList = list;
    }
}
