
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderChange.rq;

import java.io.Serializable;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;

/** 
 * A sitting place for a passenger located in the cabin.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/2015/00/2019.1/IATA_OrderChangeRQ" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="SeatType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="ColumnID" minOccurs="1" maxOccurs="1"/>
 *     &lt;xs:element type="xs:integer" name="RowNumber" minOccurs="1" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="SeatCharacteristicCode" minOccurs="0" maxOccurs="99"/>
 *     &lt;xs:element type="xs:string" name="SeatProfileRefID" minOccurs="1" maxOccurs="1"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class SeatType implements Serializable
{
    private String columnID;
    private BigInteger rowNumber;
    private List<String> seatCharacteristicCodeList = new ArrayList<String>();
    private String seatProfileRefID;

    /** 
     * Get the 'ColumnID' element value. Alphabetic character identifying a seat within a row.
     * 
     * @return value
     */
    public String getColumnID() {
        return columnID;
    }

    /** 
     * Set the 'ColumnID' element value. Alphabetic character identifying a seat within a row.
     * 
     * @param columnID
     */
    public void setColumnID(String columnID) {
        this.columnID = columnID;
    }

    /** 
     * Get the 'RowNumber' element value. Ordinal number identifying a seat row in an aircraft.
     * 
     * @return value
     */
    public BigInteger getRowNumber() {
        return rowNumber;
    }

    /** 
     * Set the 'RowNumber' element value. Ordinal number identifying a seat row in an aircraft.
     * 
     * @param rowNumber
     */
    public void setRowNumber(BigInteger rowNumber) {
        this.rowNumber = rowNumber;
    }

    /** 
     * Get the list of 'SeatCharacteristicCode' element items. Characteristic of an aircraft seat e.g. A (Aisle seat), E (Exit and emergency exit),..., according to PADIS code list 9825.
     * 
     * @return list
     */
    public List<String> getSeatCharacteristicCodeList() {
        return seatCharacteristicCodeList;
    }

    /** 
     * Set the list of 'SeatCharacteristicCode' element items. Characteristic of an aircraft seat e.g. A (Aisle seat), E (Exit and emergency exit),..., according to PADIS code list 9825.
     * 
     * @param list
     */
    public void setSeatCharacteristicCodeList(List<String> list) {
        seatCharacteristicCodeList = list;
    }

    /** 
     * Get the 'SeatProfileRefID' element value. Reference to a Seat Profile ID within this message.
     * 
     * @return value
     */
    public String getSeatProfileRefID() {
        return seatProfileRefID;
    }

    /** 
     * Set the 'SeatProfileRefID' element value. Reference to a Seat Profile ID within this message.
     * 
     * @param seatProfileRefID
     */
    public void setSeatProfileRefID(String seatProfileRefID) {
        this.seatProfileRefID = seatProfileRefID;
    }
}
