
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderChange.rq;

import java.io.Serializable;

/** 
 * Data returned from the Directory Server/ACS containing the PAReq and the ACS URL that enable to cardholder to authenticate.  Applicable for 3D Secure Version V 1.0.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/2015/00/2019.1/IATA_OrderChangeRQ" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="SecurePayerAuthenticationInstructionsType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="AuthenticationTrxID" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="MerchantData" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="PayerAuthenticationRequestText" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="RedirectionURL" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="TerminationURL" minOccurs="0" maxOccurs="1"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class SecurePayerAuthenticationInstructionsType implements Serializable
{
    private String authenticationTrxID;
    private String merchantData;
    private String payerAuthenticationRequestText;
    private String redirectionURL;
    private String terminationURL;

    /** 
     * Get the 'AuthenticationTrxID' element value. Unique 3D Secure transaction reference number assigned by Access Control System (ACS). Example: Qzl3WVc1TVpXNW5kR2crUEcxbGMzTmhaMlZK WkQ1UVFWSmxjUzB4TWpnNUSXcKTmprNU5EWThMMjFsYzNOaFoyVkpRDQ4TDAxRVBqd3ZVVEr  Note: This is typically required for ACS systems that support Status Query.
     * 
     * @return value
     */
    public String getAuthenticationTrxID() {
        return authenticationTrxID;
    }

    /** 
     * Set the 'AuthenticationTrxID' element value. Unique 3D Secure transaction reference number assigned by Access Control System (ACS). Example: Qzl3WVc1TVpXNW5kR2crUEcxbGMzTmhaMlZK WkQ1UVFWSmxjUzB4TWpnNUSXcKTmprNU5EWThMMjFsYzNOaFoyVkpRDQ4TDAxRVBqd3ZVVEr  Note: This is typically required for ACS systems that support Status Query.
     * 
     * @param authenticationTrxID
     */
    public void setAuthenticationTrxID(String authenticationTrxID) {
        this.authenticationTrxID = authenticationTrxID;
    }

    /** 
     * Get the 'MerchantData' element value. Containing merchant state data that must be returned to the merchant.
     * 
     * @return value
     */
    public String getMerchantData() {
        return merchantData;
    }

    /** 
     * Set the 'MerchantData' element value. Containing merchant state data that must be returned to the merchant.
     * 
     * @param merchantData
     */
    public void setMerchantData(String merchantData) {
        this.merchantData = merchantData;
    }

    /** 
     * Get the 'PayerAuthenticationRequestText' element value. The authentication request for the 3-D Secure transaction. When sending the customerâ€™s browser to the card issuerâ€™s ACS, the  system will need to include the PaReq in the HTTPS POST. Example: eJzVWFmzosgSfudXdPQ8Gt1sbkzYRhQ7KCjI/sYOsimgoL/+lp7Tp5c5t2d67tMw8yv/WqiluJXS8WyyVFEQT28qz
     * 
     * @return value
     */
    public String getPayerAuthenticationRequestText() {
        return payerAuthenticationRequestText;
    }

    /** 
     * Set the 'PayerAuthenticationRequestText' element value. The authentication request for the 3-D Secure transaction. When sending the customerâ€™s browser to the card issuerâ€™s ACS, the  system will need to include the PaReq in the HTTPS POST. Example: eJzVWFmzosgSfudXdPQ8Gt1sbkzYRhQ7KCjI/sYOsimgoL/+lp7Tp5c5t2d67tMw8yv/WqiluJXS8WyyVFEQT28qz
     * 
     * @param payerAuthenticationRequestText
     */
    public void setPayerAuthenticationRequestText(
            String payerAuthenticationRequestText) {
        this.payerAuthenticationRequestText = payerAuthenticationRequestText;
    }

    /** 
     * Get the 'RedirectionURL' element value. 3DS Access Control System URL.  Note: This is the URL of the Issuing Bank's ACS, to which the cardholder needs to be re-directed. The browser should simply redirect to this URL.  ACS or Access Control Server
     * 
     * @return value
     */
    public String getRedirectionURL() {
        return redirectionURL;
    }

    /** 
     * Set the 'RedirectionURL' element value. 3DS Access Control System URL.  Note: This is the URL of the Issuing Bank's ACS, to which the cardholder needs to be re-directed. The browser should simply redirect to this URL.  ACS or Access Control Server
     * 
     * @param redirectionURL
     */
    public void setRedirectionURL(String redirectionURL) {
        this.redirectionURL = redirectionURL;
    }

    /** 
     * Get the 'TerminationURL' element value. The URL to which the user will be directed to at the conclusion of 3D secure authentication. Example: http://ba.com/paymentResultSuccess
     * 
     * @return value
     */
    public String getTerminationURL() {
        return terminationURL;
    }

    /** 
     * Set the 'TerminationURL' element value. The URL to which the user will be directed to at the conclusion of 3D secure authentication. Example: http://ba.com/paymentResultSuccess
     * 
     * @param terminationURL
     */
    public void setTerminationURL(String terminationURL) {
        this.terminationURL = terminationURL;
    }
}
