
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderChange.rq;

import java.io.Serializable;

/** 
 * Contains the indicators and fields that convey the result of the 3D Secure authentication transaction.  Applicable for 3D Secure Version V 1.0.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/2015/00/2019.1/IATA_OrderChangeRQ" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="SecurePayerAuthenticationType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="PayerAuthenticationResponseText" minOccurs="0" maxOccurs="1"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class SecurePayerAuthenticationType implements Serializable
{
    private String payerAuthenticationResponseText;

    /** 
     * Get the 'PayerAuthenticationResponseText' element value. The authentication response for the 3-D Secure transaction. It is used to determine whether or not the customer has been authenticated by the card issuer. It must be included in the final authorization request. Example: eJzVWFmzosgSfudXdPQ8Gt1sbkzYRhQ7KCjI/sYOsimgoL/+lp7Tp5c5t2d67tMw8yv/WqiluJXS8WyyVFEQT28qz
     * 
     * @return value
     */
    public String getPayerAuthenticationResponseText() {
        return payerAuthenticationResponseText;
    }

    /** 
     * Set the 'PayerAuthenticationResponseText' element value. The authentication response for the 3-D Secure transaction. It is used to determine whether or not the customer has been authenticated by the card issuer. It must be included in the final authorization request. Example: eJzVWFmzosgSfudXdPQ8Gt1sbkzYRhQ7KCjI/sYOsimgoL/+lp7Tp5c5t2d67tMw8yv/WqiluJXS8WyyVFEQT28qz
     * 
     * @param payerAuthenticationResponseText
     */
    public void setPayerAuthenticationResponseText(
            String payerAuthenticationResponseText) {
        this.payerAuthenticationResponseText = payerAuthenticationResponseText;
    }
}
