
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderChange.rq;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * OfferItem selected by the Passenger for inclusion in the requested Order. Repeat occurrence of OfferItem (once per passenger) if different passengers want to select different service options, different quantities of a-la-carte items or different seat locations.   As a minimum, all mandatory OfferItems from a desired Offer should be explicitly defined within these selections and should repeat the same Passenger and Flight Segment associations defined in the originating OfferItems. Optional OfferItems may then be appended as further items selected by the Passenger.   OfferItems from the originating Offers may take on two different forms, which in turn drives how the ALaCarteSelection element is to be used - If the OfferItem referenced comes originally from an a-la-carte Offer, then the use of the ALaCarteSelection element should be used to defined the Quantity of said OfferItem. On the other hand, if the OfferItem comes from a standard type of Offer in the previous shopping response, the ALaCarteSelection element should not be used, as the quantity is explicitly driven by what is defined in that OfferItemâ€™s associations (to passengers and/or flight segments).
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/2015/00/2019.1/IATA_OrderChangeRQ" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="SelectedOfferItemType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="OfferItemRefID" minOccurs="1" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="PaxRefID" minOccurs="1" maxOccurs="unbounded"/>
 *     &lt;xs:element type="ns:SelectedALaCarteOfferItemType" name="SelectedALaCarteOfferItem" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:SelectedBundleServicesType" name="SelectedBundleServices" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:SelectedSeatType" name="SelectedSeat" minOccurs="0" maxOccurs="1"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class SelectedOfferItemType implements Serializable
{
    private String offerItemRefID;
    private List<String> paxRefIDList = new ArrayList<String>();
    private SelectedALaCarteOfferItemType selectedALaCarteOfferItem;
    private SelectedBundleServicesType selectedBundleServices;
    private SelectedSeatType selectedSeat;

    /** 
     * Get the 'OfferItemRefID' element value. Reference to the OfferItemID of the selected OfferItem (contained in either a standard Offer or an a-la-carte Offer) returned in a previous shopping response.
     * 
     * @return value
     */
    public String getOfferItemRefID() {
        return offerItemRefID;
    }

    /** 
     * Set the 'OfferItemRefID' element value. Reference to the OfferItemID of the selected OfferItem (contained in either a standard Offer or an a-la-carte Offer) returned in a previous shopping response.
     * 
     * @param offerItemRefID
     */
    public void setOfferItemRefID(String offerItemRefID) {
        this.offerItemRefID = offerItemRefID;
    }

    /** 
     * Get the list of 'PaxRefID' element items. Reference to passenger(s) for which this OfferItem and selected Services (in case of Service Bundles) applies.
     * 
     * @return list
     */
    public List<String> getPaxRefIDList() {
        return paxRefIDList;
    }

    /** 
     * Set the list of 'PaxRefID' element items. Reference to passenger(s) for which this OfferItem and selected Services (in case of Service Bundles) applies.
     * 
     * @param list
     */
    public void setPaxRefIDList(List<String> list) {
        paxRefIDList = list;
    }

    /** 
     * Get the 'SelectedALaCarteOfferItem' element value. Use to select the quantity of Offer Items from the A La Carte Offer Items.
     * 
     * @return value
     */
    public SelectedALaCarteOfferItemType getSelectedALaCarteOfferItem() {
        return selectedALaCarteOfferItem;
    }

    /** 
     * Set the 'SelectedALaCarteOfferItem' element value. Use to select the quantity of Offer Items from the A La Carte Offer Items.
     * 
     * @param selectedALaCarteOfferItem
     */
    public void setSelectedALaCarteOfferItem(
            SelectedALaCarteOfferItemType selectedALaCarteOfferItem) {
        this.selectedALaCarteOfferItem = selectedALaCarteOfferItem;
    }

    /** 
     * Get the 'SelectedBundleServices' element value. For service bundle selection - only to be used for bundles with optional choices (e.g. pick 2 out of 4)
     * 
     * @return value
     */
    public SelectedBundleServicesType getSelectedBundleServices() {
        return selectedBundleServices;
    }

    /** 
     * Set the 'SelectedBundleServices' element value. For service bundle selection - only to be used for bundles with optional choices (e.g. pick 2 out of 4)
     * 
     * @param selectedBundleServices
     */
    public void setSelectedBundleServices(
            SelectedBundleServicesType selectedBundleServices) {
        this.selectedBundleServices = selectedBundleServices;
    }

    /** 
     * Get the 'SelectedSeat' element value. Selection of specific seat location, as provided in seat availability messages.  When used, only a single Passenger must be referenced for a single Segment.
     * 
     * @return value
     */
    public SelectedSeatType getSelectedSeat() {
        return selectedSeat;
    }

    /** 
     * Set the 'SelectedSeat' element value. Selection of specific seat location, as provided in seat availability messages.  When used, only a single Passenger must be referenced for a single Segment.
     * 
     * @param selectedSeat
     */
    public void setSelectedSeat(SelectedSeatType selectedSeat) {
        this.selectedSeat = selectedSeat;
    }
}
