
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderChange.rq;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Choice to determine if the information of this ServiceDefinition needs to be extended with specific Bag or Seat characteristics, or whether the ServiceDefinition is used as a bundle of further ServiceDefinitions.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/2015/00/2019.1/IATA_OrderChangeRQ" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ServiceDefinitionAssociationType">
 *   &lt;xs:choice>
 *     &lt;xs:element type="xs:string" name="BaggageAllowanceRefID" minOccurs="1" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="SeatProfileRefID" minOccurs="1" maxOccurs="unbounded"/>
 *     &lt;xs:element type="ns:ServiceBundleType" name="ServiceBundle" minOccurs="1" maxOccurs="1"/>
 *   &lt;/xs:choice>
 * &lt;/xs:complexType>
 * </pre>
 */
public class ServiceDefinitionAssociationType implements Serializable
{
    private int choiceSelect = -1;
    private static final int BAGGAGE_ALLOWANCE_REF_ID_CHOICE = 0;
    private static final int SEAT_PROFILE_REF_ID_LIST_CHOICE = 1;
    private static final int SERVICE_BUNDLE_CHOICE = 2;
    private String baggageAllowanceRefID;
    private List<String> seatProfileRefIDList = new ArrayList<String>();
    private ServiceBundleType serviceBundle;

    private void setChoiceSelect(int choice) {
        if (choiceSelect == -1) {
            choiceSelect = choice;
        } else if (choiceSelect != choice) {
            throw new IllegalStateException(
                    "Need to call clearChoiceSelect() before changing existing choice");
        }
    }

    /** 
     * Clear the choice selection.
     */
    public void clearChoiceSelect() {
        choiceSelect = -1;
    }

    /** 
     * Check if BaggageAllowanceRefID is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifBaggageAllowanceRefID() {
        return choiceSelect == BAGGAGE_ALLOWANCE_REF_ID_CHOICE;
    }

    /** 
     * Get the 'BaggageAllowanceRefID' element value. Reference to a Baggage Allowance ID within this message.
     * 
     * @return value
     */
    public String getBaggageAllowanceRefID() {
        return baggageAllowanceRefID;
    }

    /** 
     * Set the 'BaggageAllowanceRefID' element value. Reference to a Baggage Allowance ID within this message.
     * 
     * @param baggageAllowanceRefID
     */
    public void setBaggageAllowanceRefID(String baggageAllowanceRefID) {
        setChoiceSelect(BAGGAGE_ALLOWANCE_REF_ID_CHOICE);
        this.baggageAllowanceRefID = baggageAllowanceRefID;
    }

    /** 
     * Check if SeatProfileRefIDList is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifSeatProfileRefIDList() {
        return choiceSelect == SEAT_PROFILE_REF_ID_LIST_CHOICE;
    }

    /** 
     * Get the list of 'SeatProfileRefID' element items. Reference to a Seat Profile ID within this message.
     * 
     * @return list
     */
    public List<String> getSeatProfileRefIDList() {
        return seatProfileRefIDList;
    }

    /** 
     * Set the list of 'SeatProfileRefID' element items. Reference to a Seat Profile ID within this message.
     * 
     * @param list
     */
    public void setSeatProfileRefIDList(List<String> list) {
        setChoiceSelect(SEAT_PROFILE_REF_ID_LIST_CHOICE);
        seatProfileRefIDList = list;
    }

    /** 
     * Check if ServiceBundle is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifServiceBundle() {
        return choiceSelect == SERVICE_BUNDLE_CHOICE;
    }

    /** 
     * Get the 'ServiceBundle' element value. Where several services are offered for sale as one service.
     * 
     * @return value
     */
    public ServiceBundleType getServiceBundle() {
        return serviceBundle;
    }

    /** 
     * Set the 'ServiceBundle' element value. Where several services are offered for sale as one service.
     * 
     * @param serviceBundle
     */
    public void setServiceBundle(ServiceBundleType serviceBundle) {
        setChoiceSelect(SERVICE_BUNDLE_CHOICE);
        this.serviceBundle = serviceBundle;
    }
}
