
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderChange.rq;

import java.io.Serializable;

/** 
 * The instance of a specific flight or Service Definition as it has been offered (and eventually ordered and consumed) in the context of a specific Offer and/or Order.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/2015/00/2019.1/IATA_OrderChangeRQ" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ServiceType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="AccountingCode" minOccurs="1" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="AccountingSubCode" minOccurs="1" maxOccurs="1"/>
 *     &lt;xs:element type="ns:ActionContentType" name="ActionCode" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:BagType" name="Bag" minOccurs="1" maxOccurs="1"/>
 *     &lt;xs:element type="ns:ServiceBookingStatusContentType" name="BookingStatusCode" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="DeliveryCode" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="DeliveryMilestoneCode" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:ServiceDeliveryStatusContentType" name="DeliveryStatusCode" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:DateTimeType" name="ExpirationDateTime" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:InterlineSettlementInfoType" name="InterlineSettlementInfo" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="PaxRefID" minOccurs="1" maxOccurs="1"/>
 *     &lt;xs:element type="ns:ServiceAssociationsType" name="ServiceAssociations" minOccurs="1" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="ServiceID" minOccurs="1" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="ServiceRefID" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="StatusCode" minOccurs="0" maxOccurs="1"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class ServiceType implements Serializable
{
    private String accountingCode;
    private String accountingSubCode;
    private ActionContentType actionCode;
    private BagType bag;
    private ServiceBookingStatusContentType bookingStatusCode;
    private String deliveryCode;
    private String deliveryMilestoneCode;
    private ServiceDeliveryStatusContentType deliveryStatusCode;
    private DateTimeType expirationDateTime;
    private InterlineSettlementInfoType interlineSettlementInfo;
    private String paxRefID;
    private ServiceAssociationsType serviceAssociations;
    private String serviceID;
    private String serviceRefID;
    private String statusCode;

    /** 
     * Get the 'AccountingCode' element value. Grouping of services might be mapped to RFIC
     * 
     * @return value
     */
    public String getAccountingCode() {
        return accountingCode;
    }

    /** 
     * Set the 'AccountingCode' element value. Grouping of services might be mapped to RFIC
     * 
     * @param accountingCode
     */
    public void setAccountingCode(String accountingCode) {
        this.accountingCode = accountingCode;
    }

    /** 
     * Get the 'AccountingSubCode' element value. Service identifier might be mapped to RFISC
     * 
     * @return value
     */
    public String getAccountingSubCode() {
        return accountingSubCode;
    }

    /** 
     * Set the 'AccountingSubCode' element value. Service identifier might be mapped to RFISC
     * 
     * @param accountingSubCode
     */
    public void setAccountingSubCode(String accountingSubCode) {
        this.accountingSubCode = accountingSubCode;
    }

    /** 
     * Get the 'ActionCode' element value. To indicate the creation, update and removal of a service
     * 
     * @return value
     */
    public ActionContentType getActionCode() {
        return actionCode;
    }

    /** 
     * Set the 'ActionCode' element value. To indicate the creation, update and removal of a service
     * 
     * @param actionCode
     */
    public void setActionCode(ActionContentType actionCode) {
        this.actionCode = actionCode;
    }

    /** 
     * Get the 'Bag' element value. A piece of luggage associated with a passenger, packed for traveling, and necessary or appropriate in connection with a journey.
     * 
     * @return value
     */
    public BagType getBag() {
        return bag;
    }

    /** 
     * Set the 'Bag' element value. A piece of luggage associated with a passenger, packed for traveling, and necessary or appropriate in connection with a journey.
     * 
     * @param bag
     */
    public void setBag(BagType bag) {
        this.bag = bag;
    }

    /** 
     * Get the 'BookingStatusCode' element value. Indicates the current status of a Service booking.
     * 
     * @return value
     */
    public ServiceBookingStatusContentType getBookingStatusCode() {
        return bookingStatusCode;
    }

    /** 
     * Set the 'BookingStatusCode' element value. Indicates the current status of a Service booking.
     * 
     * @param bookingStatusCode
     */
    public void setBookingStatusCode(
            ServiceBookingStatusContentType bookingStatusCode) {
        this.bookingStatusCode = bookingStatusCode;
    }

    /** 
     * Get the 'DeliveryCode' element value. Grouping of services on delivery aspects
     * 
     * @return value
     */
    public String getDeliveryCode() {
        return deliveryCode;
    }

    /** 
     * Set the 'DeliveryCode' element value. Grouping of services on delivery aspects
     * 
     * @param deliveryCode
     */
    public void setDeliveryCode(String deliveryCode) {
        this.deliveryCode = deliveryCode;
    }

    /** 
     * Get the 'DeliveryMilestoneCode' element value. Records an event in the lifecycle of a service delivery that may or may not occur independently of a change of service status, e.g. passenger boarded, passenger accepted airside, bag loaded or offloaded. Exploratory functionality
     * 
     * @return value
     */
    public String getDeliveryMilestoneCode() {
        return deliveryMilestoneCode;
    }

    /** 
     * Set the 'DeliveryMilestoneCode' element value. Records an event in the lifecycle of a service delivery that may or may not occur independently of a change of service status, e.g. passenger boarded, passenger accepted airside, bag loaded or offloaded. Exploratory functionality
     * 
     * @param deliveryMilestoneCode
     */
    public void setDeliveryMilestoneCode(String deliveryMilestoneCode) {
        this.deliveryMilestoneCode = deliveryMilestoneCode;
    }

    /** 
     * Get the 'DeliveryStatusCode' element value. Indicates the current status of a Service delivery
     * 
     * @return value
     */
    public ServiceDeliveryStatusContentType getDeliveryStatusCode() {
        return deliveryStatusCode;
    }

    /** 
     * Set the 'DeliveryStatusCode' element value. Indicates the current status of a Service delivery
     * 
     * @param deliveryStatusCode
     */
    public void setDeliveryStatusCode(
            ServiceDeliveryStatusContentType deliveryStatusCode) {
        this.deliveryStatusCode = deliveryStatusCode;
    }

    /** 
     * Get the 'ExpirationDateTime' element value. Used to recognize the expiration of a service delivery e.g. lounge pass expiry date.
     * 
     * @return value
     */
    public DateTimeType getExpirationDateTime() {
        return expirationDateTime;
    }

    /** 
     * Set the 'ExpirationDateTime' element value. Used to recognize the expiration of a service delivery e.g. lounge pass expiry date.
     * 
     * @param expirationDateTime
     */
    public void setExpirationDateTime(DateTimeType expirationDateTime) {
        this.expirationDateTime = expirationDateTime;
    }

    /** 
     * Get the 'InterlineSettlementInfo' element value. Information related to the value of a product or service as it pertains to interline transactions.
     * 
     * @return value
     */
    public InterlineSettlementInfoType getInterlineSettlementInfo() {
        return interlineSettlementInfo;
    }

    /** 
     * Set the 'InterlineSettlementInfo' element value. Information related to the value of a product or service as it pertains to interline transactions.
     * 
     * @param interlineSettlementInfo
     */
    public void setInterlineSettlementInfo(
            InterlineSettlementInfoType interlineSettlementInfo) {
        this.interlineSettlementInfo = interlineSettlementInfo;
    }

    /** 
     * Get the 'PaxRefID' element value. Uniquely identifies a Passenger within the context of one message.
     * 
     * @return value
     */
    public String getPaxRefID() {
        return paxRefID;
    }

    /** 
     * Set the 'PaxRefID' element value. Uniquely identifies a Passenger within the context of one message.
     * 
     * @param paxRefID
     */
    public void setPaxRefID(String paxRefID) {
        this.paxRefID = paxRefID;
    }

    /** 
     * Get the 'ServiceAssociations' element value. References to the details of this Service.  May include either Passenger Journeys, a Service Definition, or a Selected Seat.
     * 
     * @return value
     */
    public ServiceAssociationsType getServiceAssociations() {
        return serviceAssociations;
    }

    /** 
     * Set the 'ServiceAssociations' element value. References to the details of this Service.  May include either Passenger Journeys, a Service Definition, or a Selected Seat.
     * 
     * @param serviceAssociations
     */
    public void setServiceAssociations(
            ServiceAssociationsType serviceAssociations) {
        this.serviceAssociations = serviceAssociations;
    }

    /** 
     * Get the 'ServiceID' element value. Uniquely Identifies a Service within the context of one message.
     * 
     * @return value
     */
    public String getServiceID() {
        return serviceID;
    }

    /** 
     * Set the 'ServiceID' element value. Uniquely Identifies a Service within the context of one message.
     * 
     * @param serviceID
     */
    public void setServiceID(String serviceID) {
        this.serviceID = serviceID;
    }

    /** 
     * Get the 'ServiceRefID' element value. Uniquely Identifies a Service within the context of one message.
     * 
     * @return value
     */
    public String getServiceRefID() {
        return serviceRefID;
    }

    /** 
     * Set the 'ServiceRefID' element value. Uniquely Identifies a Service within the context of one message.
     * 
     * @param serviceRefID
     */
    public void setServiceRefID(String serviceRefID) {
        this.serviceRefID = serviceRefID;
    }

    /** 
     * Get the 'StatusCode' element value. Status of the Service instance. See PADIS Codelist 4405 for possible values.
     * 
     * @return value
     */
    public String getStatusCode() {
        return statusCode;
    }

    /** 
     * Set the 'StatusCode' element value. Status of the Service instance. See PADIS Codelist 4405 for possible values.
     * 
     * @param statusCode
     */
    public void setStatusCode(String statusCode) {
        this.statusCode = statusCode;
    }
}
