
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderChange.rq;

import java.io.Serializable;

/** 
 * Location or facility where air or surface transportation originates, stops and/or terminates, and where passengers and/or cargo can be taken on or off.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/2015/00/2019.1/IATA_OrderChangeRQ" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="StationType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="IATA_LocationCode" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="StationName" minOccurs="0" maxOccurs="1"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class StationType implements Serializable
{
    private String IATALocationCode;
    private String stationName;

    /** 
     * Get the 'IATA_LocationCode' element value. IATA defined code identifying a city or station.
     * 
     * @return value
     */
    public String getIATALocationCode() {
        return IATALocationCode;
    }

    /** 
     * Set the 'IATA_LocationCode' element value. IATA defined code identifying a city or station.
     * 
     * @param IATALocationCode
     */
    public void setIATALocationCode(String IATALocationCode) {
        this.IATALocationCode = IATALocationCode;
    }

    /** 
     * Get the 'StationName' element value. Name of the station. E.g. George Bush Intercontinental Airport
     * 
     * @return value
     */
    public String getStationName() {
        return stationName;
    }

    /** 
     * Set the 'StationName' element value. Name of the station. E.g. George Bush Intercontinental Airport
     * 
     * @param stationName
     */
    public void setStationName(String stationName) {
        this.stationName = stationName;
    }
}
