
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderChange.rq;

import java.io.Serializable;

/** 
 * Store date and time in a structured way
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://xml.amadeus.com/QUQMDQ_03_1_1A" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="StructuredDateTimeType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="year"/>
 *     &lt;xs:element type="xs:string" name="month"/>
 *     &lt;xs:element type="xs:string" name="day"/>
 *     &lt;xs:element type="xs:string" name="hour" minOccurs="0"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class StructuredDateTimeType1 implements Serializable
{
    private String year;
    private String month;
    private String day;
    private String hour;

    /** 
     * Get the 'year' element value. Year number. The format is a little long for short term usage but it can be reduced by implementation if required.
     * 
     * @return value
     */
    public String getYear() {
        return year;
    }

    /** 
     * Set the 'year' element value. Year number. The format is a little long for short term usage but it can be reduced by implementation if required.
     * 
     * @param year
     */
    public void setYear(String year) {
        this.year = year;
    }

    /** 
     * Get the 'month' element value. Month number in the year ( begins to 1 )
     * 
     * @return value
     */
    public String getMonth() {
        return month;
    }

    /** 
     * Set the 'month' element value. Month number in the year ( begins to 1 )
     * 
     * @param month
     */
    public void setMonth(String month) {
        this.month = month;
    }

    /** 
     * Get the 'day' element value. Day number in the month ( begins to 1 )
     * 
     * @return value
     */
    public String getDay() {
        return day;
    }

    /** 
     * Set the 'day' element value. Day number in the month ( begins to 1 )
     * 
     * @param day
     */
    public void setDay(String day) {
        this.day = day;
    }

    /** 
     * Get the 'hour' element value. Hour between 0 and 23
     * 
     * @return value
     */
    public String getHour() {
        return hour;
    }

    /** 
     * Set the 'hour' element value. Hour between 0 and 23
     * 
     * @param hour
     */
    public void setHour(String hour) {
        this.hour = hour;
    }
}
