
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderChange.rq;

import java.io.Serializable;

/** 
 * The action or process of leaving of a transport vehicle from any place or location.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/2015/00/2019.1/IATA_OrderChangeRQ" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TransportDepType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:DateTimeType" name="AircraftScheduledDateTime" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="BoardingGateID" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="IATA_LocationCode" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="StationName" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="TerminalName" minOccurs="0" maxOccurs="1"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class TransportDepType implements Serializable
{
    private DateTimeType aircraftScheduledDateTime;
    private String boardingGateID;
    private String IATALocationCode;
    private String stationName;
    private String terminalName;

    /** 
     * Get the 'AircraftScheduledDateTime' element value. The Scheduled Date and Time of Departure of the aircraft at the terminal or departure gate at an airport.
     * 
     * @return value
     */
    public DateTimeType getAircraftScheduledDateTime() {
        return aircraftScheduledDateTime;
    }

    /** 
     * Set the 'AircraftScheduledDateTime' element value. The Scheduled Date and Time of Departure of the aircraft at the terminal or departure gate at an airport.
     * 
     * @param aircraftScheduledDateTime
     */
    public void setAircraftScheduledDateTime(
            DateTimeType aircraftScheduledDateTime) {
        this.aircraftScheduledDateTime = aircraftScheduledDateTime;
    }

    /** 
     * Get the 'BoardingGateID' element value. Identifier of the gate. E.g. â€œA5â€&#157;.
     * 
     * @return value
     */
    public String getBoardingGateID() {
        return boardingGateID;
    }

    /** 
     * Set the 'BoardingGateID' element value. Identifier of the gate. E.g. â€œA5â€&#157;.
     * 
     * @param boardingGateID
     */
    public void setBoardingGateID(String boardingGateID) {
        this.boardingGateID = boardingGateID;
    }

    /** 
     * Get the 'IATA_LocationCode' element value. IATA defined code identifying a city or station.
     * 
     * @return value
     */
    public String getIATALocationCode() {
        return IATALocationCode;
    }

    /** 
     * Set the 'IATA_LocationCode' element value. IATA defined code identifying a city or station.
     * 
     * @param IATALocationCode
     */
    public void setIATALocationCode(String IATALocationCode) {
        this.IATALocationCode = IATALocationCode;
    }

    /** 
     * Get the 'StationName' element value. Name of the station. E.g. George Bush Intercontinental Airport
     * 
     * @return value
     */
    public String getStationName() {
        return stationName;
    }

    /** 
     * Set the 'StationName' element value. Name of the station. E.g. George Bush Intercontinental Airport
     * 
     * @param stationName
     */
    public void setStationName(String stationName) {
        this.stationName = stationName;
    }

    /** 
     * Get the 'TerminalName' element value. The name of the terminal.
     * 
     * @return value
     */
    public String getTerminalName() {
        return terminalName;
    }

    /** 
     * Set the 'TerminalName' element value. The name of the terminal.
     * 
     * @param terminalName
     */
    public void setTerminalName(String terminalName) {
        this.terminalName = terminalName;
    }
}
