
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderChange.rq;

import java.io.Serializable;

/** 
 * Collection of functions used by the seller to request the airline to commit changes to an existing Order. These may be adding, removing or replacing Order Items (with potential refund conditions, in case of cancellations). The actions possible are determined by the airline and communicated to the seller at the time of an OrderReshopRS (which precedes OrderChangeRQ). It is up to the seller to then accept the proposed actions from the OrderReshopRS by echoing these functions in this OrderServicing structure
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/2015/00/2019.1/IATA_OrderChangeRQ" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="UpdateOrderItemType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:AcceptOfferType" name="AcceptOffer" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:DeleteOrderItemType" name="DeleteOrderItem" minOccurs="0" maxOccurs="1"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class UpdateOrderItemType implements Serializable
{
    private AcceptOfferType acceptOffer;
    private DeleteOrderItemType deleteOrderItem;

    /** 
     * Get the 'AcceptOffer' element value. Function to accept a new OfferItem and adding it to the existing Order.
     * 
     * @return value
     */
    public AcceptOfferType getAcceptOffer() {
        return acceptOffer;
    }

    /** 
     * Set the 'AcceptOffer' element value. Function to accept a new OfferItem and adding it to the existing Order.
     * 
     * @param acceptOffer
     */
    public void setAcceptOffer(AcceptOfferType acceptOffer) {
        this.acceptOffer = acceptOffer;
    }

    /** 
     * Get the 'DeleteOrderItem' element value. Function to accept the deletion of an OrderItem from the existing Order.
     * 
     * @return value
     */
    public DeleteOrderItemType getDeleteOrderItem() {
        return deleteOrderItem;
    }

    /** 
     * Set the 'DeleteOrderItem' element value. Function to accept the deletion of an OrderItem from the existing Order.
     * 
     * @param deleteOrderItem
     */
    public void setDeleteOrderItem(DeleteOrderItemType deleteOrderItem) {
        this.deleteOrderItem = deleteOrderItem;
    }
}
