
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderChange.rq;

import java.io.Serializable;
import java.sql.Date;

/** 
 * An official entry in a Passport or other Travel Document made by an official of a government to indicate that the bearer has been granted authority to enter or re-enter the country or region concerned.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/2015/00/2019.1/IATA_OrderChangeRQ" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="VisaType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:date" name="EnterBeforeDate" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:QtyType" name="EntryQty" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="HostCountryCode" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="StayDuration" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="VisaID" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="VisaTypeCode" minOccurs="0" maxOccurs="1"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class VisaType implements Serializable
{
    private Date enterBeforeDate;
    private QtyType entryQty;
    private String hostCountryCode;
    private String stayDuration;
    private String visaID;
    private String visaTypeCode;

    /** 
     * Get the 'EnterBeforeDate' element value. Date at which the visa expires and is no longer a valid entry document.
     * 
     * @return value
     */
    public Date getEnterBeforeDate() {
        return enterBeforeDate;
    }

    /** 
     * Set the 'EnterBeforeDate' element value. Date at which the visa expires and is no longer a valid entry document.
     * 
     * @param enterBeforeDate
     */
    public void setEnterBeforeDate(Date enterBeforeDate) {
        this.enterBeforeDate = enterBeforeDate;
    }

    /** 
     * Get the 'EntryQty' element value. Number of entries permitted by the visa into the host country.
     * 
     * @return value
     */
    public QtyType getEntryQty() {
        return entryQty;
    }

    /** 
     * Set the 'EntryQty' element value. Number of entries permitted by the visa into the host country.
     * 
     * @param entryQty
     */
    public void setEntryQty(QtyType entryQty) {
        this.entryQty = entryQty;
    }

    /** 
     * Get the 'HostCountryCode' element value. ISO Country Code where the visa is valid.
     * 
     * @return value
     */
    public String getHostCountryCode() {
        return hostCountryCode;
    }

    /** 
     * Set the 'HostCountryCode' element value. ISO Country Code where the visa is valid.
     * 
     * @param hostCountryCode
     */
    public void setHostCountryCode(String hostCountryCode) {
        this.hostCountryCode = hostCountryCode;
    }

    /** 
     * Get the 'StayDuration' element value. Duration permitted of the Passenger's stay in the visa host country (in days).
     * 
     * @return value
     */
    public String getStayDuration() {
        return stayDuration;
    }

    /** 
     * Set the 'StayDuration' element value. Duration permitted of the Passenger's stay in the visa host country (in days).
     * 
     * @param stayDuration
     */
    public void setStayDuration(String stayDuration) {
        this.stayDuration = stayDuration;
    }

    /** 
     * Get the 'VisaID' element value. Visa ID value. Example: NY122345.
     * 
     * @return value
     */
    public String getVisaID() {
        return visaID;
    }

    /** 
     * Set the 'VisaID' element value. Visa ID value. Example: NY122345.
     * 
     * @param visaID
     */
    public void setVisaID(String visaID) {
        this.visaID = visaID;
    }

    /** 
     * Get the 'VisaTypeCode' element value. The type of visa.
     * 
     * @return value
     */
    public String getVisaTypeCode() {
        return visaTypeCode;
    }

    /** 
     * Set the 'VisaTypeCode' element value. The type of visa.
     * 
     * @param visaTypeCode
     */
    public void setVisaTypeCode(String visaTypeCode) {
        this.visaTypeCode = visaTypeCode;
    }
}
