
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderReshop.rq;

import java.io.Serializable;

/** 
 * Action to request new Offer Items for the specified Order.  If used in conjunction with a â€œDeleteâ€&#157; function, the intention is to replace the deleted item with whatever has been requested in this Add functionâ€™s shopping query.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/2015/00/2019.1/IATA_OrderReshopRQ" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AddOfferItemsType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:FlightRequestType" name="FlightCriteria" minOccurs="1" maxOccurs="1"/>
 *     &lt;xs:element type="ns:PaxsType" name="Paxs" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:ResponseParametersType" name="ResponseParameters" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:ShoppingCriteriaType" name="ShoppingCriteria" minOccurs="0" maxOccurs="1"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class AddOfferItemsType implements Serializable
{
    private FlightRequestType flightCriteria;
    private PaxsType paxs;
    private ResponseParametersType responseParameters;
    private ShoppingCriteriaType shoppingCriteria;

    /** 
     * Get the 'FlightCriteria' element value. Choice of Affinity, Origin Destination, or Journey flight information for this shopping request.
     * 
     * @return value
     */
    public FlightRequestType getFlightCriteria() {
        return flightCriteria;
    }

    /** 
     * Set the 'FlightCriteria' element value. Choice of Affinity, Origin Destination, or Journey flight information for this shopping request.
     * 
     * @param flightCriteria
     */
    public void setFlightCriteria(FlightRequestType flightCriteria) {
        this.flightCriteria = flightCriteria;
    }

    /** 
     * Get the 'Paxs' element value. Passenger and Passenger Group information.
     * 
     * @return value
     */
    public PaxsType getPaxs() {
        return paxs;
    }

    /** 
     * Set the 'Paxs' element value. Passenger and Passenger Group information.
     * 
     * @param paxs
     */
    public void setPaxs(PaxsType paxs) {
        this.paxs = paxs;
    }

    /** 
     * Get the 'ResponseParameters' element value. Information related to how shopping results should be returned in the response.
     * 
     * @return value
     */
    public ResponseParametersType getResponseParameters() {
        return responseParameters;
    }

    /** 
     * Set the 'ResponseParameters' element value. Information related to how shopping results should be returned in the response.
     * 
     * @param responseParameters
     */
    public void setResponseParameters(ResponseParametersType responseParameters) {
        this.responseParameters = responseParameters;
    }

    /** 
     * Get the 'ShoppingCriteria' element value. Further qualifies the flight request by influencing which results are returned in the shopping response, including preferred or required criteria.
     * 
     * @return value
     */
    public ShoppingCriteriaType getShoppingCriteria() {
        return shoppingCriteria;
    }

    /** 
     * Set the 'ShoppingCriteria' element value. Further qualifies the flight request by influencing which results are returned in the shopping response, including preferred or required criteria.
     * 
     * @param shoppingCriteria
     */
    public void setShoppingCriteria(ShoppingCriteriaType shoppingCriteria) {
        this.shoppingCriteria = shoppingCriteria;
    }
}
