
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderReshop.rq;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Baggage pricing specific filter criteria for shopping requests, including baggage type, charges, and settlement information.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/2015/00/2019.1/IATA_OrderReshopRQ" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="BaggagePricingCriteriaType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:BaggageTypeCodeContentType" name="BaggageOptionCode" minOccurs="0" maxOccurs="2"/>
 *     &lt;xs:element type="xs:string" name="CommercialAgreementID" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:boolean" name="DeferralInd" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:boolean" name="FixedPrepaidInd" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:boolean" name="IncludeSettlementInd" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="OptionalChargesCode" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="RequestedActionCode" minOccurs="0" maxOccurs="1"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class BaggagePricingCriteriaType implements Serializable
{
    private List<BaggageTypeCodeContentType> baggageOptionCodeList = new ArrayList<BaggageTypeCodeContentType>();
    private String commercialAgreementID;
    private Boolean deferralInd;
    private Boolean fixedPrepaidInd;
    private Boolean includeSettlementInd;
    private String optionalChargesCode;
    private String requestedActionCode;

    /** 
     * Get the list of 'BaggageOptionCode' element items. Specifies the type of baggage (e.g. CarryOnBag, CheckedBag).
     * 
     * @return list
     */
    public List<BaggageTypeCodeContentType> getBaggageOptionCodeList() {
        return baggageOptionCodeList;
    }

    /** 
     * Set the list of 'BaggageOptionCode' element items. Specifies the type of baggage (e.g. CarryOnBag, CheckedBag).
     * 
     * @param list
     */
    public void setBaggageOptionCodeList(List<BaggageTypeCodeContentType> list) {
        baggageOptionCodeList = list;
    }

    /** 
     * Get the 'CommercialAgreementID' element value. Bilateral agreement identifier.
     * 
     * @return value
     */
    public String getCommercialAgreementID() {
        return commercialAgreementID;
    }

    /** 
     * Set the 'CommercialAgreementID' element value. Bilateral agreement identifier.
     * 
     * @param commercialAgreementID
     */
    public void setCommercialAgreementID(String commercialAgreementID) {
        this.commercialAgreementID = commercialAgreementID;
    }

    /** 
     * Get the 'DeferralInd' element value. When TRUE, the ORA advises that the POA is given BDC designation.
     * 
     * @return value
     */
    public Boolean getDeferralInd() {
        return deferralInd;
    }

    /** 
     * Set the 'DeferralInd' element value. When TRUE, the ORA advises that the POA is given BDC designation.
     * 
     * @param deferralInd
     */
    public void setDeferralInd(Boolean deferralInd) {
        this.deferralInd = deferralInd;
    }

    /** 
     * Get the 'FixedPrepaidInd' element value. When TRUE, the ORA may alter the POA's prepaid baggage charges.
     * 
     * @return value
     */
    public Boolean getFixedPrepaidInd() {
        return fixedPrepaidInd;
    }

    /** 
     * Set the 'FixedPrepaidInd' element value. When TRUE, the ORA may alter the POA's prepaid baggage charges.
     * 
     * @param fixedPrepaidInd
     */
    public void setFixedPrepaidInd(Boolean fixedPrepaidInd) {
        this.fixedPrepaidInd = fixedPrepaidInd;
    }

    /** 
     * Get the 'IncludeSettlementInd' element value. When TRUE, the POA is requested to return the settlement value for the baggage.
     * 
     * @return value
     */
    public Boolean getIncludeSettlementInd() {
        return includeSettlementInd;
    }

    /** 
     * Set the 'IncludeSettlementInd' element value. When TRUE, the POA is requested to return the settlement value for the baggage.
     * 
     * @param includeSettlementInd
     */
    public void setIncludeSettlementInd(Boolean includeSettlementInd) {
        this.includeSettlementInd = includeSettlementInd;
    }

    /** 
     * Get the 'OptionalChargesCode' element value. Allowance catalog requested.  Example: C (Catalog Only).
     * 
     * @return value
     */
    public String getOptionalChargesCode() {
        return optionalChargesCode;
    }

    /** 
     * Set the 'OptionalChargesCode' element value. Allowance catalog requested.  Example: C (Catalog Only).
     * 
     * @param optionalChargesCode
     */
    public void setOptionalChargesCode(String optionalChargesCode) {
        this.optionalChargesCode = optionalChargesCode;
    }

    /** 
     * Get the 'RequestedActionCode' element value. Requested action to take for this information (example: 131 DISPLAY ONLY).
     * 
     * @return value
     */
    public String getRequestedActionCode() {
        return requestedActionCode;
    }

    /** 
     * Set the 'RequestedActionCode' element value. Requested action to take for this information (example: 131 DISPLAY ONLY).
     * 
     * @param requestedActionCode
     */
    public void setRequestedActionCode(String requestedActionCode) {
        this.requestedActionCode = requestedActionCode;
    }
}
