
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderReshop.rq;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/** 
 * Customer's requested connection information.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/2015/00/2019.1/IATA_OrderReshopRQ" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ConnectionCriteriaType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="ConnectionPrefID" minOccurs="1" maxOccurs="1"/>
 *     &lt;xs:element type="xs:boolean" name="ConnectionPricingInd" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:boolean" name="InterlineInd" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:QtyType" name="MaximumConnectionQty" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:dateTime" name="MaximumConnectionTime" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:dateTime" name="MinimumConnectionTime" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:StationCriteriaType" name="StationCriteria" minOccurs="1" maxOccurs="unbounded"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class ConnectionCriteriaType implements Serializable
{
    private String connectionPrefID;
    private Boolean connectionPricingInd;
    private Boolean interlineInd;
    private QtyType maximumConnectionQty;
    private Date maximumConnectionTime;
    private Date minimumConnectionTime;
    private List<StationCriteriaType> stationCriteriaList = new ArrayList<StationCriteriaType>();

    /** 
     * Get the 'ConnectionPrefID' element value. Unique identifier assigned to this connection preference.
     * 
     * @return value
     */
    public String getConnectionPrefID() {
        return connectionPrefID;
    }

    /** 
     * Set the 'ConnectionPrefID' element value. Unique identifier assigned to this connection preference.
     * 
     * @param connectionPrefID
     */
    public void setConnectionPrefID(String connectionPrefID) {
        this.connectionPrefID = connectionPrefID;
    }

    /** 
     * Get the 'ConnectionPricingInd' element value. When TRUE, connection pricing should be applied.
     * 
     * @return value
     */
    public Boolean getConnectionPricingInd() {
        return connectionPricingInd;
    }

    /** 
     * Set the 'ConnectionPricingInd' element value. When TRUE, connection pricing should be applied.
     * 
     * @param connectionPricingInd
     */
    public void setConnectionPricingInd(Boolean connectionPricingInd) {
        this.connectionPricingInd = connectionPricingInd;
    }

    /** 
     * Get the 'InterlineInd' element value. When TRUE, an interline connection is preferred.
     * 
     * @return value
     */
    public Boolean getInterlineInd() {
        return interlineInd;
    }

    /** 
     * Set the 'InterlineInd' element value. When TRUE, an interline connection is preferred.
     * 
     * @param interlineInd
     */
    public void setInterlineInd(Boolean interlineInd) {
        this.interlineInd = interlineInd;
    }

    /** 
     * Get the 'MaximumConnectionQty' element value. Maximum number of connections.
     * 
     * @return value
     */
    public QtyType getMaximumConnectionQty() {
        return maximumConnectionQty;
    }

    /** 
     * Set the 'MaximumConnectionQty' element value. Maximum number of connections.
     * 
     * @param maximumConnectionQty
     */
    public void setMaximumConnectionQty(QtyType maximumConnectionQty) {
        this.maximumConnectionQty = maximumConnectionQty;
    }

    /** 
     * Get the 'MaximumConnectionTime' element value. Maximum connection time preference.
     * 
     * @return value
     */
    public Date getMaximumConnectionTime() {
        return maximumConnectionTime;
    }

    /** 
     * Set the 'MaximumConnectionTime' element value. Maximum connection time preference.
     * 
     * @param maximumConnectionTime
     */
    public void setMaximumConnectionTime(Date maximumConnectionTime) {
        this.maximumConnectionTime = maximumConnectionTime;
    }

    /** 
     * Get the 'MinimumConnectionTime' element value. Minimum connection time preference.
     * 
     * @return value
     */
    public Date getMinimumConnectionTime() {
        return minimumConnectionTime;
    }

    /** 
     * Set the 'MinimumConnectionTime' element value. Minimum connection time preference.
     * 
     * @param minimumConnectionTime
     */
    public void setMinimumConnectionTime(Date minimumConnectionTime) {
        this.minimumConnectionTime = minimumConnectionTime;
    }

    /** 
     * Get the list of 'StationCriteria' element items. The customer's requested Station criteria.
     * 
     * @return list
     */
    public List<StationCriteriaType> getStationCriteriaList() {
        return stationCriteriaList;
    }

    /** 
     * Set the list of 'StationCriteria' element items. The customer's requested Station criteria.
     * 
     * @param list
     */
    public void setStationCriteriaList(List<StationCriteriaType> list) {
        stationCriteriaList = list;
    }
}
