
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderReshop.rq;

import java.io.Serializable;
import java.sql.Date;

/** 
 * A Customer's requested Destination arrival time and location.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/2015/00/2019.1/IATA_OrderReshopRQ" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="DestArrivalCriteriaType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="BoardingGateID" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:date" name="Date" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="IATA_LocationCode" minOccurs="1" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="StationName" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="TerminalName" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:dateTime" name="Time" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:MeasureType" name="TimeAfterMeasure" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:MeasureType" name="TimeBeforeMeasure" minOccurs="0" maxOccurs="1"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class DestArrivalCriteriaType implements Serializable
{
    private String boardingGateID;
    private Date date;
    private String IATALocationCode;
    private String stationName;
    private String terminalName;
    private java.util.Date time;
    private MeasureType timeAfterMeasure;
    private MeasureType timeBeforeMeasure;

    /** 
     * Get the 'BoardingGateID' element value. Identifier of the gate. E.g. â€œA5â€&#157;.
     * 
     * @return value
     */
    public String getBoardingGateID() {
        return boardingGateID;
    }

    /** 
     * Set the 'BoardingGateID' element value. Identifier of the gate. E.g. â€œA5â€&#157;.
     * 
     * @param boardingGateID
     */
    public void setBoardingGateID(String boardingGateID) {
        this.boardingGateID = boardingGateID;
    }

    /** 
     * Get the 'Date' element value. The customer's requested departure date.
     * 
     * @return value
     */
    public Date getDate() {
        return date;
    }

    /** 
     * Set the 'Date' element value. The customer's requested departure date.
     * 
     * @param date
     */
    public void setDate(Date date) {
        this.date = date;
    }

    /** 
     * Get the 'IATA_LocationCode' element value. IATA defined code identifying a city or station.
     * 
     * @return value
     */
    public String getIATALocationCode() {
        return IATALocationCode;
    }

    /** 
     * Set the 'IATA_LocationCode' element value. IATA defined code identifying a city or station.
     * 
     * @param IATALocationCode
     */
    public void setIATALocationCode(String IATALocationCode) {
        this.IATALocationCode = IATALocationCode;
    }

    /** 
     * Get the 'StationName' element value. Name of the station. E.g. George Bush Intercontinental Airport
     * 
     * @return value
     */
    public String getStationName() {
        return stationName;
    }

    /** 
     * Set the 'StationName' element value. Name of the station. E.g. George Bush Intercontinental Airport
     * 
     * @param stationName
     */
    public void setStationName(String stationName) {
        this.stationName = stationName;
    }

    /** 
     * Get the 'TerminalName' element value. The name of the terminal.
     * 
     * @return value
     */
    public String getTerminalName() {
        return terminalName;
    }

    /** 
     * Set the 'TerminalName' element value. The name of the terminal.
     * 
     * @param terminalName
     */
    public void setTerminalName(String terminalName) {
        this.terminalName = terminalName;
    }

    /** 
     * Get the 'Time' element value. The customer's requested departure time.
     * 
     * @return value
     */
    public java.util.Date getTime() {
        return time;
    }

    /** 
     * Set the 'Time' element value. The customer's requested departure time.
     * 
     * @param time
     */
    public void setTime(java.util.Date time) {
        this.time = time;
    }

    /** 
     * Get the 'TimeAfterMeasure' element value. Time tolerance measured in hours or days.
     * 
     * @return value
     */
    public MeasureType getTimeAfterMeasure() {
        return timeAfterMeasure;
    }

    /** 
     * Set the 'TimeAfterMeasure' element value. Time tolerance measured in hours or days.
     * 
     * @param timeAfterMeasure
     */
    public void setTimeAfterMeasure(MeasureType timeAfterMeasure) {
        this.timeAfterMeasure = timeAfterMeasure;
    }

    /** 
     * Get the 'TimeBeforeMeasure' element value. Time tolerance measured in hours or days.
     * 
     * @return value
     */
    public MeasureType getTimeBeforeMeasure() {
        return timeBeforeMeasure;
    }

    /** 
     * Set the 'TimeBeforeMeasure' element value. Time tolerance measured in hours or days.
     * 
     * @param timeBeforeMeasure
     */
    public void setTimeBeforeMeasure(MeasureType timeBeforeMeasure) {
        this.timeBeforeMeasure = timeBeforeMeasure;
    }
}
