
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderReshop.rq;

import java.io.Serializable;

/** 
 * Device upon which the secure transaction will occur.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/2015/00/2019.1/IATA_OrderReshopRQ" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="DeviceType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="DeviceCode" minOccurs="1" maxOccurs="1"/>
 *     &lt;xs:element type="ns:GeospatialLocationType" name="GeospatialLocation" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="TouchPointTrxCode" minOccurs="0" maxOccurs="1"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class DeviceType implements Serializable
{
    private String deviceCode;
    private GeospatialLocationType geospatialLocation;
    private String touchPointTrxCode;

    /** 
     * Get the 'DeviceCode' element value. The device code from which the request was initiated.
     * 
     * @return value
     */
    public String getDeviceCode() {
        return deviceCode;
    }

    /** 
     * Set the 'DeviceCode' element value. The device code from which the request was initiated.
     * 
     * @param deviceCode
     */
    public void setDeviceCode(String deviceCode) {
        this.deviceCode = deviceCode;
    }

    /** 
     * Get the 'GeospatialLocation' element value. A location with a spatial attribute, probably on the surface of the earth. For example: Longitude and Latitude
     * 
     * @return value
     */
    public GeospatialLocationType getGeospatialLocation() {
        return geospatialLocation;
    }

    /** 
     * Set the 'GeospatialLocation' element value. A location with a spatial attribute, probably on the surface of the earth. For example: Longitude and Latitude
     * 
     * @param geospatialLocation
     */
    public void setGeospatialLocation(GeospatialLocationType geospatialLocation) {
        this.geospatialLocation = geospatialLocation;
    }

    /** 
     * Get the 'TouchPointTrxCode' element value. The travel event that triggered the request.  Example: Order/buy, Check-In, In Flight.  PADIS codeset TTT
     * 
     * @return value
     */
    public String getTouchPointTrxCode() {
        return touchPointTrxCode;
    }

    /** 
     * Set the 'TouchPointTrxCode' element value. The travel event that triggered the request.  Example: Order/buy, Check-In, In Flight.  PADIS codeset TTT
     * 
     * @param touchPointTrxCode
     */
    public void setTouchPointTrxCode(String touchPointTrxCode) {
        this.touchPointTrxCode = touchPointTrxCode;
    }
}
