
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderReshop.rq;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Fare criteria used to filter shopping results.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/2015/00/2019.1/IATA_OrderReshopRQ" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FareCriteriaType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="FareBasisCode" minOccurs="0" maxOccurs="unbounded"/>
 *     &lt;xs:element type="xs:string" name="FareTypeCode" minOccurs="0" maxOccurs="unbounded"/>
 *     &lt;xs:element type="ns:GroupFareCriteriaType" name="GroupFareCriteria" minOccurs="0" maxOccurs="unbounded"/>
 *     &lt;xs:element type="xs:boolean" name="NoAdvancePurchaseInd" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:boolean" name="NoMaxStayInd" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:boolean" name="NoMinStayInd" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:boolean" name="NoPenaltyInd" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:PrefLevelType" name="PrefLevel" minOccurs="1" maxOccurs="1"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class FareCriteriaType implements Serializable
{
    private List<String> fareBasisCodeList = new ArrayList<String>();
    private List<String> fareTypeCodeList = new ArrayList<String>();
    private List<GroupFareCriteriaType> groupFareCriteriaList = new ArrayList<GroupFareCriteriaType>();
    private Boolean noAdvancePurchaseInd;
    private Boolean noMaxStayInd;
    private Boolean noMinStayInd;
    private Boolean noPenaltyInd;
    private PrefLevelType prefLevel;

    /** 
     * Get the list of 'FareBasisCode' element items. Fare basis code. Example: Y26
     * 
     * @return list
     */
    public List<String> getFareBasisCodeList() {
        return fareBasisCodeList;
    }

    /** 
     * Set the list of 'FareBasisCode' element items. Fare basis code. Example: Y26
     * 
     * @param list
     */
    public void setFareBasisCodeList(List<String> list) {
        fareBasisCodeList = list;
    }

    /** 
     * Get the list of 'FareTypeCode' element items. Fare type.  Examples: 70J-Published Fares, 749-Negotiated Fares, 756-One Way Fare,  758-Private Fares  Encoding Scheme: PADIS codeset element 9910 - Fare Qualifier
     * 
     * @return list
     */
    public List<String> getFareTypeCodeList() {
        return fareTypeCodeList;
    }

    /** 
     * Set the list of 'FareTypeCode' element items. Fare type.  Examples: 70J-Published Fares, 749-Negotiated Fares, 756-One Way Fare,  758-Private Fares  Encoding Scheme: PADIS codeset element 9910 - Fare Qualifier
     * 
     * @param list
     */
    public void setFareTypeCodeList(List<String> list) {
        fareTypeCodeList = list;
    }

    /** 
     * Get the list of 'GroupFareCriteria' element items. Group Fare preferences by passenger type
     * 
     * @return list
     */
    public List<GroupFareCriteriaType> getGroupFareCriteriaList() {
        return groupFareCriteriaList;
    }

    /** 
     * Set the list of 'GroupFareCriteria' element items. Group Fare preferences by passenger type
     * 
     * @param list
     */
    public void setGroupFareCriteriaList(List<GroupFareCriteriaType> list) {
        groupFareCriteriaList = list;
    }

    /** 
     * Get the 'NoAdvancePurchaseInd' element value. When true, do not return fares with advance purchase restrictions.
     * 
     * @return value
     */
    public Boolean getNoAdvancePurchaseInd() {
        return noAdvancePurchaseInd;
    }

    /** 
     * Set the 'NoAdvancePurchaseInd' element value. When true, do not return fares with advance purchase restrictions.
     * 
     * @param noAdvancePurchaseInd
     */
    public void setNoAdvancePurchaseInd(Boolean noAdvancePurchaseInd) {
        this.noAdvancePurchaseInd = noAdvancePurchaseInd;
    }

    /** 
     * Get the 'NoMaxStayInd' element value. When true, do not return fares with maximum stay restrictions.
     * 
     * @return value
     */
    public Boolean getNoMaxStayInd() {
        return noMaxStayInd;
    }

    /** 
     * Set the 'NoMaxStayInd' element value. When true, do not return fares with maximum stay restrictions.
     * 
     * @param noMaxStayInd
     */
    public void setNoMaxStayInd(Boolean noMaxStayInd) {
        this.noMaxStayInd = noMaxStayInd;
    }

    /** 
     * Get the 'NoMinStayInd' element value. When true, do not return fares with minimum stay restrictions.
     * 
     * @return value
     */
    public Boolean getNoMinStayInd() {
        return noMinStayInd;
    }

    /** 
     * Set the 'NoMinStayInd' element value. When true, do not return fares with minimum stay restrictions.
     * 
     * @param noMinStayInd
     */
    public void setNoMinStayInd(Boolean noMinStayInd) {
        this.noMinStayInd = noMinStayInd;
    }

    /** 
     * Get the 'NoPenaltyInd' element value. When true, do not return fares with penalties.
     * 
     * @return value
     */
    public Boolean getNoPenaltyInd() {
        return noPenaltyInd;
    }

    /** 
     * Set the 'NoPenaltyInd' element value. When true, do not return fares with penalties.
     * 
     * @param noPenaltyInd
     */
    public void setNoPenaltyInd(Boolean noPenaltyInd) {
        this.noPenaltyInd = noPenaltyInd;
    }

    /** 
     * Get the 'PrefLevel' element value. Information supporting a preference including preference level code (e.g. Preferred, Exclude, etc.).
     * 
     * @return value
     */
    public PrefLevelType getPrefLevel() {
        return prefLevel;
    }

    /** 
     * Set the 'PrefLevel' element value. Information supporting a preference including preference level code (e.g. Preferred, Exclude, etc.).
     * 
     * @param prefLevel
     */
    public void setPrefLevel(PrefLevelType prefLevel) {
        this.prefLevel = prefLevel;
    }
}
