
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderReshop.rq;

import java.io.Serializable;

/** 
 * Enumeration set for the flight characteristics code BDT.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:simpleType xmlns:ns="http://www.iata.org/IATA/2015/00/2019.1/IATA_OrderReshopRQ" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FlightCharacteristicCodeContentType">
 *   &lt;xs:restriction base="xs:string">
 *     &lt;xs:enumeration value="AirportChange"/>
 *     &lt;xs:enumeration value="Direct"/>
 *     &lt;xs:enumeration value="NonStop"/>
 *     &lt;xs:enumeration value="OvernightStop"/>
 *     &lt;xs:enumeration value="RedEye"/>
 *     &lt;xs:enumeration value="WaitList"/>
 *   &lt;/xs:restriction>
 * &lt;/xs:simpleType>
 * </pre>
 */
public enum FlightCharacteristicCodeContentType implements Serializable {
    AIRPORT_CHANGE("AirportChange"), DIRECT("Direct"), NON_STOP("NonStop"), OVERNIGHT_STOP(
            "OvernightStop"), RED_EYE("RedEye"), WAIT_LIST("WaitList");
    private final String value;

    private FlightCharacteristicCodeContentType(String value) {
        this.value = value;
    }

    public String xmlValue() {
        return value;
    }

    public static FlightCharacteristicCodeContentType convert(String value) {
        for (FlightCharacteristicCodeContentType inst : values()) {
            if (inst.xmlValue().equals(value)) {
                return inst;
            }
        }
        return null;
    }
}
