
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderReshop.rq;

import java.io.Serializable;

/** 
 * Flight characteristics filter criteria for shopping requests, including non-stop, red eye, etc.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/2015/00/2019.1/IATA_OrderReshopRQ" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FlightCharacteristicsCriteriaType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:FlightCharacteristicCodeContentType" name="CharacteristicCode" minOccurs="1" maxOccurs="1"/>
 *     &lt;xs:element type="ns:PrefLevelType" name="PrefLevel" minOccurs="1" maxOccurs="1"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class FlightCharacteristicsCriteriaType implements Serializable
{
    private FlightCharacteristicCodeContentType characteristicCode;
    private PrefLevelType prefLevel;

    /** 
     * Get the 'CharacteristicCode' element value. Code to identify the type of flight characteristic (including non-stop, red eye, etc.)
     * 
     * @return value
     */
    public FlightCharacteristicCodeContentType getCharacteristicCode() {
        return characteristicCode;
    }

    /** 
     * Set the 'CharacteristicCode' element value. Code to identify the type of flight characteristic (including non-stop, red eye, etc.)
     * 
     * @param characteristicCode
     */
    public void setCharacteristicCode(
            FlightCharacteristicCodeContentType characteristicCode) {
        this.characteristicCode = characteristicCode;
    }

    /** 
     * Get the 'PrefLevel' element value. Information supporting a preference including preference level code (e.g. Preferred, Exclude, etc.).
     * 
     * @return value
     */
    public PrefLevelType getPrefLevel() {
        return prefLevel;
    }

    /** 
     * Set the 'PrefLevel' element value. Information supporting a preference including preference level code (e.g. Preferred, Exclude, etc.).
     * 
     * @param prefLevel
     */
    public void setPrefLevel(PrefLevelType prefLevel) {
        this.prefLevel = prefLevel;
    }
}
