
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderReshop.rq;

import java.io.Serializable;

/** 
 * Total journey travel time preferences.  This includes the sum of all flight durations as well as connection times.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/2015/00/2019.1/IATA_OrderReshopRQ" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="JourneyDurationCriteriaType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:MeasureType" name="MaximumTimeMeasure" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:PrefLevelCodeContentType" name="PrefCode" minOccurs="0" maxOccurs="1"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class JourneyDurationCriteriaType implements Serializable
{
    private MeasureType maximumTimeMeasure;
    private PrefLevelCodeContentType prefCode;

    /** 
     * Get the 'MaximumTimeMeasure' element value. Preferred maximum time for this Journey.
     * 
     * @return value
     */
    public MeasureType getMaximumTimeMeasure() {
        return maximumTimeMeasure;
    }

    /** 
     * Set the 'MaximumTimeMeasure' element value. Preferred maximum time for this Journey.
     * 
     * @param maximumTimeMeasure
     */
    public void setMaximumTimeMeasure(MeasureType maximumTimeMeasure) {
        this.maximumTimeMeasure = maximumTimeMeasure;
    }

    /** 
     * Get the 'PrefCode' element value. Level of preference requested.  Examples: Preferred, Required, or Exclude.
     * 
     * @return value
     */
    public PrefLevelCodeContentType getPrefCode() {
        return prefCode;
    }

    /** 
     * Set the 'PrefCode' element value. Level of preference requested.  Examples: Preferred, Required, or Exclude.
     * 
     * @param prefCode
     */
    public void setPrefCode(PrefLevelCodeContentType prefCode) {
        this.prefCode = prefCode;
    }
}
