
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderReshop.rq;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * A priced grouping of one or more services within an Offer.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/2015/00/2019.1/IATA_OrderReshopRQ" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OfferItemType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="OfferItemID" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="OwnerCode" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:ServiceType" name="Service" minOccurs="0" maxOccurs="unbounded"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class OfferItemType implements Serializable
{
    private String offerItemID;
    private String ownerCode;
    private List<ServiceType> serviceList = new ArrayList<ServiceType>();

    /** 
     * Get the 'OfferItemID' element value. Carrier assigned ID which exists uniquely within an Offer.
     * 
     * @return value
     */
    public String getOfferItemID() {
        return offerItemID;
    }

    /** 
     * Set the 'OfferItemID' element value. Carrier assigned ID which exists uniquely within an Offer.
     * 
     * @param offerItemID
     */
    public void setOfferItemID(String offerItemID) {
        this.offerItemID = offerItemID;
    }

    /** 
     * Get the 'OwnerCode' element value. Airline code assigned to a carrier. Either ICAO-defined 3-character code or IATA-defined 2-character code.
     * 
     * @return value
     */
    public String getOwnerCode() {
        return ownerCode;
    }

    /** 
     * Set the 'OwnerCode' element value. Airline code assigned to a carrier. Either ICAO-defined 3-character code or IATA-defined 2-character code.
     * 
     * @param ownerCode
     */
    public void setOwnerCode(String ownerCode) {
        this.ownerCode = ownerCode;
    }

    /** 
     * Get the list of 'Service' element items. The instance of a specific flight or Service Definition as it has been offered (and eventually ordered and consumed) in the context of a specific Offer and/or Order.
     * 
     * @return list
     */
    public List<ServiceType> getServiceList() {
        return serviceList;
    }

    /** 
     * Set the list of 'Service' element items. The instance of a specific flight or Service Definition as it has been offered (and eventually ordered and consumed) in the context of a specific Offer and/or Order.
     * 
     * @param list
     */
    public void setServiceList(List<ServiceType> list) {
        serviceList = list;
    }
}
