
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderReshop.rq;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * An individually priced item within an Order, made up of one or more Services. May or may not be a selected Offer Item (e.g. non-chargeable Services available on request such as a wheelchair).
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/2015/00/2019.1/IATA_OrderReshopRQ" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OrderItemType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="OrderItemID" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="OwnerCode" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:OwnerTypeCodeContentType" name="OwnerTypeCode" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:ServiceType" name="Service" minOccurs="0" maxOccurs="unbounded"/>
 *     &lt;xs:element type="ns:OrderItemStatusCodeContentType" name="StatusCode" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="WebAddressURI" minOccurs="0" maxOccurs="1"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class OrderItemType implements Serializable
{
    private String orderItemID;
    private String ownerCode;
    private OwnerTypeCodeContentType ownerTypeCode;
    private List<ServiceType> serviceList = new ArrayList<ServiceType>();
    private OrderItemStatusCodeContentType statusCode;
    private String webAddressURI;

    /** 
     * Get the 'OrderItemID' element value. Carrier assigned ID which exists uniquely within an Order.
     * 
     * @return value
     */
    public String getOrderItemID() {
        return orderItemID;
    }

    /** 
     * Set the 'OrderItemID' element value. Carrier assigned ID which exists uniquely within an Order.
     * 
     * @param orderItemID
     */
    public void setOrderItemID(String orderItemID) {
        this.orderItemID = orderItemID;
    }

    /** 
     * Get the 'OwnerCode' element value. Airline code assigned to a carrier. Either ICAO-defined 3-character code or IATA-defined 2-character code.
     * 
     * @return value
     */
    public String getOwnerCode() {
        return ownerCode;
    }

    /** 
     * Set the 'OwnerCode' element value. Airline code assigned to a carrier. Either ICAO-defined 3-character code or IATA-defined 2-character code.
     * 
     * @param ownerCode
     */
    public void setOwnerCode(String ownerCode) {
        this.ownerCode = ownerCode;
    }

    /** 
     * Get the 'OwnerTypeCode' element value. Indicates whether or not the owner is the ORA or POA.
     * 
     * @return value
     */
    public OwnerTypeCodeContentType getOwnerTypeCode() {
        return ownerTypeCode;
    }

    /** 
     * Set the 'OwnerTypeCode' element value. Indicates whether or not the owner is the ORA or POA.
     * 
     * @param ownerTypeCode
     */
    public void setOwnerTypeCode(OwnerTypeCodeContentType ownerTypeCode) {
        this.ownerTypeCode = ownerTypeCode;
    }

    /** 
     * Get the list of 'Service' element items. The instance of a specific flight or Service Definition as it has been offered (and eventually ordered and consumed) in the context of a specific Offer and/or Order.
     * 
     * @return list
     */
    public List<ServiceType> getServiceList() {
        return serviceList;
    }

    /** 
     * Set the list of 'Service' element items. The instance of a specific flight or Service Definition as it has been offered (and eventually ordered and consumed) in the context of a specific Offer and/or Order.
     * 
     * @param list
     */
    public void setServiceList(List<ServiceType> list) {
        serviceList = list;
    }

    /** 
     * Get the 'StatusCode' element value. Indicates the current status of an Order Item.
     * 
     * @return value
     */
    public OrderItemStatusCodeContentType getStatusCode() {
        return statusCode;
    }

    /** 
     * Set the 'StatusCode' element value. Indicates the current status of an Order Item.
     * 
     * @param statusCode
     */
    public void setStatusCode(OrderItemStatusCodeContentType statusCode) {
        this.statusCode = statusCode;
    }

    /** 
     * Get the 'WebAddressURI' element value. Deep linking into another site to complete the transaction. E.g. to bring the customer directly to a page to continue with a purchase of a specific offer.
     * 
     * @return value
     */
    public String getWebAddressURI() {
        return webAddressURI;
    }

    /** 
     * Set the 'WebAddressURI' element value. Deep linking into another site to complete the transaction. E.g. to bring the customer directly to a page to continue with a purchase of a specific offer.
     * 
     * @param webAddressURI
     */
    public void setWebAddressURI(String webAddressURI) {
        this.webAddressURI = webAddressURI;
    }
}
