
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderReshop.rq;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * A uniquely identified record of the agreement of one party with another to receive products and services under specified terms and conditions. Order supports the sale of a flexible range of airline products and services that are not necessarily Journey based (e.g. subscription services).
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/2015/00/2019.1/IATA_OrderReshopRQ" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OrderType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:BookingRefType" name="BookingRef" minOccurs="0" maxOccurs="unbounded"/>
 *     &lt;xs:element type="xs:string" name="OrderID" minOccurs="1" maxOccurs="1"/>
 *     &lt;xs:element type="ns:OrderItemType" name="OrderItem" minOccurs="0" maxOccurs="unbounded"/>
 *     &lt;xs:element type="xs:string" name="OwnerCode" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:OwnerTypeCodeContentType" name="OwnerTypeCode" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="WebAddressURI" minOccurs="0" maxOccurs="1"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class OrderType implements Serializable
{
    private List<BookingRefType> bookingRefList = new ArrayList<BookingRefType>();
    private String orderID;
    private List<OrderItemType> orderItemList = new ArrayList<OrderItemType>();
    private String ownerCode;
    private OwnerTypeCodeContentType ownerTypeCode;
    private String webAddressURI;

    /** 
     * Get the list of 'BookingRef' element items. Information related to a booking or reservation.
     * 
     * @return list
     */
    public List<BookingRefType> getBookingRefList() {
        return bookingRefList;
    }

    /** 
     * Set the list of 'BookingRef' element items. Information related to a booking or reservation.
     * 
     * @param list
     */
    public void setBookingRefList(List<BookingRefType> list) {
        bookingRefList = list;
    }

    /** 
     * Get the 'OrderID' element value. Carrier assigned ID which uniquely identifies a specific Order across several messages.
     * 
     * @return value
     */
    public String getOrderID() {
        return orderID;
    }

    /** 
     * Set the 'OrderID' element value. Carrier assigned ID which uniquely identifies a specific Order across several messages.
     * 
     * @param orderID
     */
    public void setOrderID(String orderID) {
        this.orderID = orderID;
    }

    /** 
     * Get the list of 'OrderItem' element items. An individually priced item within an Order, made up of one or more Services. May or may not be a selected Offer Item (e.g. non-chargeable Services available on request such as a wheelchair).
     * 
     * @return list
     */
    public List<OrderItemType> getOrderItemList() {
        return orderItemList;
    }

    /** 
     * Set the list of 'OrderItem' element items. An individually priced item within an Order, made up of one or more Services. May or may not be a selected Offer Item (e.g. non-chargeable Services available on request such as a wheelchair).
     * 
     * @param list
     */
    public void setOrderItemList(List<OrderItemType> list) {
        orderItemList = list;
    }

    /** 
     * Get the 'OwnerCode' element value. Airline code assigned to a carrier. Either ICAO-defined 3-character code or IATA-defined 2-character code.
     * 
     * @return value
     */
    public String getOwnerCode() {
        return ownerCode;
    }

    /** 
     * Set the 'OwnerCode' element value. Airline code assigned to a carrier. Either ICAO-defined 3-character code or IATA-defined 2-character code.
     * 
     * @param ownerCode
     */
    public void setOwnerCode(String ownerCode) {
        this.ownerCode = ownerCode;
    }

    /** 
     * Get the 'OwnerTypeCode' element value. Indicates whether the owner is the ORA or POA.
     * 
     * @return value
     */
    public OwnerTypeCodeContentType getOwnerTypeCode() {
        return ownerTypeCode;
    }

    /** 
     * Set the 'OwnerTypeCode' element value. Indicates whether the owner is the ORA or POA.
     * 
     * @param ownerTypeCode
     */
    public void setOwnerTypeCode(OwnerTypeCodeContentType ownerTypeCode) {
        this.ownerTypeCode = ownerTypeCode;
    }

    /** 
     * Get the 'WebAddressURI' element value. Deep linking into another site to complete the transaction. E.g. to bring the customer directly to a page to continue with a purchase of a specific offer.
     * 
     * @return value
     */
    public String getWebAddressURI() {
        return webAddressURI;
    }

    /** 
     * Set the 'WebAddressURI' element value. Deep linking into another site to complete the transaction. E.g. to bring the customer directly to a page to continue with a purchase of a specific offer.
     * 
     * @param webAddressURI
     */
    public void setWebAddressURI(String webAddressURI) {
        this.webAddressURI = webAddressURI;
    }
}
