
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderReshop.rq;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * The Origin and Destination airport/city pair which confines a passenger journey or an aircraft flight.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/2015/00/2019.1/IATA_OrderReshopRQ" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OriginDestType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="DestStationCode" minOccurs="1" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="OriginStationCode" minOccurs="1" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="OriginDestID" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:PaxJourneyType" name="PaxJourney" minOccurs="0" maxOccurs="unbounded"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class OriginDestType implements Serializable
{
    private String destStationCode;
    private String originStationCode;
    private String originDestID;
    private List<PaxJourneyType> paxJourneyList = new ArrayList<PaxJourneyType>();

    /** 
     * Get the 'DestStationCode' element value. IATA defined code identifying a city or station.
     * 
     * @return value
     */
    public String getDestStationCode() {
        return destStationCode;
    }

    /** 
     * Set the 'DestStationCode' element value. IATA defined code identifying a city or station.
     * 
     * @param destStationCode
     */
    public void setDestStationCode(String destStationCode) {
        this.destStationCode = destStationCode;
    }

    /** 
     * Get the 'OriginStationCode' element value. IATA defined code identifying a city or station.
     * 
     * @return value
     */
    public String getOriginStationCode() {
        return originStationCode;
    }

    /** 
     * Set the 'OriginStationCode' element value. IATA defined code identifying a city or station.
     * 
     * @param originStationCode
     */
    public void setOriginStationCode(String originStationCode) {
        this.originStationCode = originStationCode;
    }

    /** 
     * Get the 'OriginDestID' element value. Uniquely identifies an Origin Destination within the context of one message.
     * 
     * @return value
     */
    public String getOriginDestID() {
        return originDestID;
    }

    /** 
     * Set the 'OriginDestID' element value. Uniquely identifies an Origin Destination within the context of one message.
     * 
     * @param originDestID
     */
    public void setOriginDestID(String originDestID) {
        this.originDestID = originDestID;
    }

    /** 
     * Get the list of 'PaxJourney' element items. A collection of segments which satisfies transportation of a passenger for a given origin and destination.
     * 
     * @return list
     */
    public List<PaxJourneyType> getPaxJourneyList() {
        return paxJourneyList;
    }

    /** 
     * Set the list of 'PaxJourney' element items. A collection of segments which satisfies transportation of a passenger for a given origin and destination.
     * 
     * @param list
     */
    public void setPaxJourneyList(List<PaxJourneyType> list) {
        paxJourneyList = list;
    }
}
