
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderReshop.rq;

import java.io.Serializable;

/** 
 * The place at which a retail transaction is carried out.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/2015/00/2019.1/IATA_OrderReshopRQ" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="POS_Type">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="AgentDutyText" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:CityType" name="City" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:CountryType" name="Country" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:DeviceType" name="Device" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:DateTimeType" name="RequestTime" minOccurs="0" maxOccurs="1"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class POSType implements Serializable
{
    private String agentDutyText;
    private CityType city;
    private CountryType country;
    private DeviceType device;
    private DateTimeType requestTime;

    /** 
     * Get the 'AgentDutyText' element value. Internally defined agent authority to request changes.
     * 
     * @return value
     */
    public String getAgentDutyText() {
        return agentDutyText;
    }

    /** 
     * Set the 'AgentDutyText' element value. Internally defined agent authority to request changes.
     * 
     * @param agentDutyText
     */
    public void setAgentDutyText(String agentDutyText) {
        this.agentDutyText = agentDutyText;
    }

    /** 
     * Get the 'City' element value. City (e.g., Dublin), town, or postal station (i.e., a postal service territory, often used in a military address, or metropolitan area)
     * 
     * @return value
     */
    public CityType getCity() {
        return city;
    }

    /** 
     * Set the 'City' element value. City (e.g., Dublin), town, or postal station (i.e., a postal service territory, often used in a military address, or metropolitan area)
     * 
     * @param city
     */
    public void setCity(CityType city) {
        this.city = city;
    }

    /** 
     * Get the 'Country' element value. A nation with its own government, occupying a particular territory.
     * 
     * @return value
     */
    public CountryType getCountry() {
        return country;
    }

    /** 
     * Set the 'Country' element value. A nation with its own government, occupying a particular territory.
     * 
     * @param country
     */
    public void setCountry(CountryType country) {
        this.country = country;
    }

    /** 
     * Get the 'Device' element value. Device upon which the secure transaction will occur.
     * 
     * @return value
     */
    public DeviceType getDevice() {
        return device;
    }

    /** 
     * Set the 'Device' element value. Device upon which the secure transaction will occur.
     * 
     * @param device
     */
    public void setDevice(DeviceType device) {
        this.device = device;
    }

    /** 
     * Get the 'RequestTime' element value. Point of sale timestamp value.  Example: 2017-01-13T13:59:38Z  Note: This may be used if the point of sale time zone differs from the message creation timestamp.
     * 
     * @return value
     */
    public DateTimeType getRequestTime() {
        return requestTime;
    }

    /** 
     * Set the 'RequestTime' element value. Point of sale timestamp value.  Example: 2017-01-13T13:59:38Z  Note: This may be used if the point of sale time zone differs from the message creation timestamp.
     * 
     * @param requestTime
     */
    public void setRequestTime(DateTimeType requestTime) {
        this.requestTime = requestTime;
    }
}
