
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderReshop.rq;

import java.io.Serializable;

/** 
 * Transportation of a passenger on a Dated Operating Segment.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/2015/00/2019.1/IATA_OrderReshopRQ" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PaxSegmentType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:TransportArrivalType" name="Arrival" minOccurs="1" maxOccurs="1"/>
 *     &lt;xs:element type="ns:CabinTypeType" name="CabinType" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:TransportDepType" name="Dep" minOccurs="1" maxOccurs="1"/>
 *     &lt;xs:element type="ns:DatedMarketingSegmentType" name="MarketingCarrierInfo" minOccurs="1" maxOccurs="1"/>
 *     &lt;xs:element type="ns:DatedOperatingSegmentType" name="OperatingCarrierInfo" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="PaxSegmentID" minOccurs="0" maxOccurs="1"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class PaxSegmentType implements Serializable
{
    private TransportArrivalType arrival;
    private CabinTypeType cabinType;
    private TransportDepType dep;
    private DatedMarketingSegmentType marketingCarrierInfo;
    private DatedOperatingSegmentType operatingCarrierInfo;
    private String paxSegmentID;

    /** 
     * Get the 'Arrival' element value. The action or process of arriving of a transport vehicle in any place or location.
     * 
     * @return value
     */
    public TransportArrivalType getArrival() {
        return arrival;
    }

    /** 
     * Set the 'Arrival' element value. The action or process of arriving of a transport vehicle in any place or location.
     * 
     * @param arrival
     */
    public void setArrival(TransportArrivalType arrival) {
        this.arrival = arrival;
    }

    /** 
     * Get the 'CabinType' element value. Type of compartment of an aircraft, offering specific services (e.g. business class, economy).
     * 
     * @return value
     */
    public CabinTypeType getCabinType() {
        return cabinType;
    }

    /** 
     * Set the 'CabinType' element value. Type of compartment of an aircraft, offering specific services (e.g. business class, economy).
     * 
     * @param cabinType
     */
    public void setCabinType(CabinTypeType cabinType) {
        this.cabinType = cabinType;
    }

    /** 
     * Get the 'Dep' element value. The action or process of leaving of a transport vehicle from any place or location.
     * 
     * @return value
     */
    public TransportDepType getDep() {
        return dep;
    }

    /** 
     * Set the 'Dep' element value. The action or process of leaving of a transport vehicle from any place or location.
     * 
     * @param dep
     */
    public void setDep(TransportDepType dep) {
        this.dep = dep;
    }

    /** 
     * Get the 'MarketingCarrierInfo' element value. The commercial designation under which a Dated Operating Segment can be booked, either under the operating carrier's designator or that of another carrier (codeshare).
     * 
     * @return value
     */
    public DatedMarketingSegmentType getMarketingCarrierInfo() {
        return marketingCarrierInfo;
    }

    /** 
     * Set the 'MarketingCarrierInfo' element value. The commercial designation under which a Dated Operating Segment can be booked, either under the operating carrier's designator or that of another carrier (codeshare).
     * 
     * @param marketingCarrierInfo
     */
    public void setMarketingCarrierInfo(
            DatedMarketingSegmentType marketingCarrierInfo) {
        this.marketingCarrierInfo = marketingCarrierInfo;
    }

    /** 
     * Get the 'OperatingCarrierInfo' element value. An operation between board point and any subsequent off point within the same flight designator. Could be one or more legs. Could also be used for other transport vehicles such as train or bus etc.
     * 
     * @return value
     */
    public DatedOperatingSegmentType getOperatingCarrierInfo() {
        return operatingCarrierInfo;
    }

    /** 
     * Set the 'OperatingCarrierInfo' element value. An operation between board point and any subsequent off point within the same flight designator. Could be one or more legs. Could also be used for other transport vehicles such as train or bus etc.
     * 
     * @param operatingCarrierInfo
     */
    public void setOperatingCarrierInfo(
            DatedOperatingSegmentType operatingCarrierInfo) {
        this.operatingCarrierInfo = operatingCarrierInfo;
    }

    /** 
     * Get the 'PaxSegmentID' element value. Uniquely identifies a Passenger Segment within the context of one message.
     * 
     * @return value
     */
    public String getPaxSegmentID() {
        return paxSegmentID;
    }

    /** 
     * Set the 'PaxSegmentID' element value. Uniquely identifies a Passenger Segment within the context of one message.
     * 
     * @param paxSegmentID
     */
    public void setPaxSegmentID(String paxSegmentID) {
        this.paxSegmentID = paxSegmentID;
    }
}
