
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderReshop.rq;

import java.io.Serializable;
import java.math.BigDecimal;

/** 
 * Requested card issuer type and identification number.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/2015/00/2019.1/IATA_OrderReshopRQ" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PaymentCardCriteriaType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="CardIssuingCountryCode" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="CardTypeCode" minOccurs="1" maxOccurs="1"/>
 *     &lt;xs:element type="ns:AmountType" name="ChargeAmount" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:PercentType" name="ChargePercent" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:decimal" name="IssuerIdentificationNumber" minOccurs="0" maxOccurs="1"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class PaymentCardCriteriaType implements Serializable
{
    private String cardIssuingCountryCode;
    private String cardTypeCode;
    private AmountType chargeAmount;
    private PercentType chargePercent;
    private BigDecimal issuerIdentificationNumber;

    /** 
     * Get the 'CardIssuingCountryCode' element value. Payment Card issuing country code.
     * 
     * @return value
     */
    public String getCardIssuingCountryCode() {
        return cardIssuingCountryCode;
    }

    /** 
     * Set the 'CardIssuingCountryCode' element value. Payment Card issuing country code.
     * 
     * @param cardIssuingCountryCode
     */
    public void setCardIssuingCountryCode(String cardIssuingCountryCode) {
        this.cardIssuingCountryCode = cardIssuingCountryCode;
    }

    /** 
     * Get the 'CardTypeCode' element value. The two letter payment card type (examples: MC, VI).
     * 
     * @return value
     */
    public String getCardTypeCode() {
        return cardTypeCode;
    }

    /** 
     * Set the 'CardTypeCode' element value. The two letter payment card type (examples: MC, VI).
     * 
     * @param cardTypeCode
     */
    public void setCardTypeCode(String cardTypeCode) {
        this.cardTypeCode = cardTypeCode;
    }

    /** 
     * Get the 'ChargeAmount' element value. Monetary amount intended to be paid on this payment card type.
     * 
     * @return value
     */
    public AmountType getChargeAmount() {
        return chargeAmount;
    }

    /** 
     * Set the 'ChargeAmount' element value. Monetary amount intended to be paid on this payment card type.
     * 
     * @param chargeAmount
     */
    public void setChargeAmount(AmountType chargeAmount) {
        this.chargeAmount = chargeAmount;
    }

    /** 
     * Get the 'ChargePercent' element value. Percent of the total Offer price amount intended to be paid on this payment card type.
     * 
     * @return value
     */
    public PercentType getChargePercent() {
        return chargePercent;
    }

    /** 
     * Set the 'ChargePercent' element value. Percent of the total Offer price amount intended to be paid on this payment card type.
     * 
     * @param chargePercent
     */
    public void setChargePercent(PercentType chargePercent) {
        this.chargePercent = chargePercent;
    }

    /** 
     * Get the 'IssuerIdentificationNumber' element value. Payment card IIN/BIN number.  Example: 401123
     * 
     * @return value
     */
    public BigDecimal getIssuerIdentificationNumber() {
        return issuerIdentificationNumber;
    }

    /** 
     * Set the 'IssuerIdentificationNumber' element value. Payment card IIN/BIN number.  Example: 401123
     * 
     * @param issuerIdentificationNumber
     */
    public void setIssuerIdentificationNumber(
            BigDecimal issuerIdentificationNumber) {
        this.issuerIdentificationNumber = issuerIdentificationNumber;
    }
}
