
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderReshop.rq;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * A form of procedure for the payment of goods or services, plus any transactional information specific to the payment method other than the amount.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/2015/00/2019.1/IATA_OrderReshopRQ" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PaymentMethodCriteriaType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="PaxRefID" minOccurs="0" maxOccurs="unbounded"/>
 *     &lt;xs:element type="xs:string" name="TypeCode" minOccurs="1" maxOccurs="unbounded"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class PaymentMethodCriteriaType implements Serializable
{
    private List<String> paxRefIDList = new ArrayList<String>();
    private List<String> typeCodeList = new ArrayList<String>();

    /** 
     * Get the list of 'PaxRefID' element items. Reference to a Passenger ID.
     * 
     * @return list
     */
    public List<String> getPaxRefIDList() {
        return paxRefIDList;
    }

    /** 
     * Set the list of 'PaxRefID' element items. Reference to a Passenger ID.
     * 
     * @param list
     */
    public void setPaxRefIDList(List<String> list) {
        paxRefIDList = list;
    }

    /** 
     * Get the list of 'TypeCode' element items. The payment method type. Examples: Credit Card, Cash.
     * 
     * @return list
     */
    public List<String> getTypeCodeList() {
        return typeCodeList;
    }

    /** 
     * Set the list of 'TypeCode' element items. The payment method type. Examples: Credit Card, Cash.
     * 
     * @param list
     */
    public void setTypeCodeList(List<String> list) {
        typeCodeList = list;
    }
}
