
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderReshop.rq;

import java.io.Serializable;

/** 
 * Level of preference requested.  Examples: Preferred, Required, or Exclude.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:simpleType xmlns:ns="http://www.iata.org/IATA/2015/00/2019.1/IATA_OrderReshopRQ" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PrefLevelCodeContentType">
 *   &lt;xs:restriction base="xs:string">
 *     &lt;xs:enumeration value="Exclude"/>
 *     &lt;xs:enumeration value="Preferred"/>
 *     &lt;xs:enumeration value="Required"/>
 *   &lt;/xs:restriction>
 * &lt;/xs:simpleType>
 * </pre>
 */
public enum PrefLevelCodeContentType implements Serializable {
    EXCLUDE("Exclude"), PREFERRED("Preferred"), /** 
                                                 * female description
                                                 */
    REQUIRED("Required");
    private final String value;

    private PrefLevelCodeContentType(String value) {
        this.value = value;
    }

    public String xmlValue() {
        return value;
    }

    public static PrefLevelCodeContentType convert(String value) {
        for (PrefLevelCodeContentType inst : values()) {
            if (inst.xmlValue().equals(value)) {
                return inst;
            }
        }
        return null;
    }
}
