
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderReshop.rq;

import java.io.Serializable;

/** 
 * Contains information to identify how reservation was re-priced to obtain best published fare (Eg. best fare in same cabin, best fare in all cabins, other parameters to select best fare).
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/2015/00/2019.1/IATA_OrderReshopRQ" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PricingMethodCriteriaType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="BestPricingOptionText" minOccurs="0" maxOccurs="1"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class PricingMethodCriteriaType implements Serializable
{
    private String bestPricingOptionText;

    /** 
     * Get the 'BestPricingOptionText' element value. Best Available Fare Pricing Method. Examples: Y (BEST FARE IN SAME CABIN CLASS) C (BEST FARE ACROSS ALL CABIN CLASSES) N (PRICE ACCORDINGLY TO OTHER DESIGNATED PRICING PARAMETERS)
     * 
     * @return value
     */
    public String getBestPricingOptionText() {
        return bestPricingOptionText;
    }

    /** 
     * Set the 'BestPricingOptionText' element value. Best Available Fare Pricing Method. Examples: Y (BEST FARE IN SAME CABIN CLASS) C (BEST FARE ACROSS ALL CABIN CLASSES) N (PRICE ACCORDINGLY TO OTHER DESIGNATED PRICING PARAMETERS)
     * 
     * @param bestPricingOptionText
     */
    public void setBestPricingOptionText(String bestPricingOptionText) {
        this.bestPricingOptionText = bestPricingOptionText;
    }
}
