
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderReshop.rq;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Pricing Parameters, including Simple Pricing, Award Travel, Auto Exchange, Override Currency and Tax Exemption.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/2015/00/2019.1/IATA_OrderReshopRQ" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PricingParameterType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:boolean" name="AutoExchInd" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:boolean" name="AwardIncludedInd" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:boolean" name="AwardOnlyInd" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="OverrideCurCode" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:boolean" name="SimplePricingInd" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:TaxSummaryType" name="TaxExemption" minOccurs="0" maxOccurs="unbounded"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class PricingParameterType implements Serializable
{
    private Boolean autoExchInd;
    private Boolean awardIncludedInd;
    private Boolean awardOnlyInd;
    private String overrideCurCode;
    private Boolean simplePricingInd;
    private List<TaxSummaryType> taxExemptionList = new ArrayList<TaxSummaryType>();

    /** 
     * Get the 'AutoExchInd' element value. When TRUE, this request is to be handled by an auto-exchange process.
     * 
     * @return value
     */
    public Boolean getAutoExchInd() {
        return autoExchInd;
    }

    /** 
     * Set the 'AutoExchInd' element value. When TRUE, this request is to be handled by an auto-exchange process.
     * 
     * @param autoExchInd
     */
    public void setAutoExchInd(Boolean autoExchInd) {
        this.autoExchInd = autoExchInd;
    }

    /** 
     * Get the 'AwardIncludedInd' element value. When TRUE, award eligible offers to be returned in addition to priced offers.
     * 
     * @return value
     */
    public Boolean getAwardIncludedInd() {
        return awardIncludedInd;
    }

    /** 
     * Set the 'AwardIncludedInd' element value. When TRUE, award eligible offers to be returned in addition to priced offers.
     * 
     * @param awardIncludedInd
     */
    public void setAwardIncludedInd(Boolean awardIncludedInd) {
        this.awardIncludedInd = awardIncludedInd;
    }

    /** 
     * Get the 'AwardOnlyInd' element value. When TRUE, only award eligible offers are requested.
     * 
     * @return value
     */
    public Boolean getAwardOnlyInd() {
        return awardOnlyInd;
    }

    /** 
     * Set the 'AwardOnlyInd' element value. When TRUE, only award eligible offers are requested.
     * 
     * @param awardOnlyInd
     */
    public void setAwardOnlyInd(Boolean awardOnlyInd) {
        this.awardOnlyInd = awardOnlyInd;
    }

    /** 
     * Get the 'OverrideCurCode' element value.
     * 
     * @return value
     */
    public String getOverrideCurCode() {
        return overrideCurCode;
    }

    /** 
     * Set the 'OverrideCurCode' element value.
     * 
     * @param overrideCurCode
     */
    public void setOverrideCurCode(String overrideCurCode) {
        this.overrideCurCode = overrideCurCode;
    }

    /** 
     * Get the 'SimplePricingInd' element value. When TRUE, simple pricing is requested for returned offers.
     * 
     * @return value
     */
    public Boolean getSimplePricingInd() {
        return simplePricingInd;
    }

    /** 
     * Set the 'SimplePricingInd' element value. When TRUE, simple pricing is requested for returned offers.
     * 
     * @param simplePricingInd
     */
    public void setSimplePricingInd(Boolean simplePricingInd) {
        this.simplePricingInd = simplePricingInd;
    }

    /** 
     * Get the list of 'TaxExemption' element items. Tax summary information.
     * 
     * @return list
     */
    public List<TaxSummaryType> getTaxExemptionList() {
        return taxExemptionList;
    }

    /** 
     * Set the list of 'TaxExemption' element items. Tax summary information.
     * 
     * @param list
     */
    public void setTaxExemptionList(List<TaxSummaryType> list) {
        taxExemptionList = list;
    }
}
