
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderReshop.rq;

import java.io.Serializable;

/** 
 * Reservation Booking Designator.  A categorization used to facilitate access to inventory, application of filed fares, and to identify cabin entitlement. Identified using a single alpha character. E.g. 'J' for Business Class Premium, 'D' for Business Discounted.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/2015/00/2019.1/IATA_OrderReshopRQ" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="RBD_Type">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="RBD_Code" minOccurs="1" maxOccurs="1"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class RBDType implements Serializable
{
    private String RBDCode;

    /** 
     * Get the 'RBD_Code' element value. Code used to identify a particular RBD (e.g. P, J, W, M, etc.).
     * 
     * @return value
     */
    public String getRBDCode() {
        return RBDCode;
    }

    /** 
     * Set the 'RBD_Code' element value. Code used to identify a particular RBD (e.g. P, J, W, M, etc.).
     * 
     * @param RBDCode
     */
    public void setRBDCode(String RBDCode) {
        this.RBDCode = RBDCode;
    }
}
