
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderReshop.rq;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Function to reprice entire Order (if only OrderID is supplied within Request) or Specific OrderItems (if defined in nested OrderItem elements)
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/2015/00/2019.1/IATA_OrderReshopRQ" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="RepriceOrderType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="OrderItemRefID" minOccurs="0" maxOccurs="unbounded"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class RepriceOrderType implements Serializable
{
    private List<String> orderItemRefIDList = new ArrayList<String>();

    /** 
     * Get the list of 'OrderItemRefID' element items. Optionally specify which OrderItem needs to be repriced.
     * 
     * @return list
     */
    public List<String> getOrderItemRefIDList() {
        return orderItemRefIDList;
    }

    /** 
     * Set the list of 'OrderItemRefID' element items. Optionally specify which OrderItem needs to be repriced.
     * 
     * @param list
     */
    public void setOrderItemRefIDList(List<String> list) {
        orderItemRefIDList = list;
    }
}
