
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderReshop.rq;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * AirShoppingRQ payload information.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/2015/00/2019.1/IATA_OrderReshopRQ" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="RequestType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:BookingRefType" name="BookingRef" minOccurs="0" maxOccurs="unbounded"/>
 *     &lt;xs:element type="xs:string" name="OrderActionContextText" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="OrderRefID" minOccurs="1" maxOccurs="1"/>
 *     &lt;xs:element type="ns:ResponseParametersType" name="ReshopParameters" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:UpdateOrderType" name="UpdateOrder" minOccurs="1" maxOccurs="1"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class RequestType implements Serializable
{
    private List<BookingRefType> bookingRefList = new ArrayList<BookingRefType>();
    private String orderActionContextText;
    private String orderRefID;
    private ResponseParametersType reshopParameters;
    private UpdateOrderType updateOrder;

    /** 
     * Get the list of 'BookingRef' element items. Information related to a booking or reservation.
     * 
     * @return list
     */
    public List<BookingRefType> getBookingRefList() {
        return bookingRefList;
    }

    /** 
     * Set the list of 'BookingRef' element items. Information related to a booking or reservation.
     * 
     * @param list
     */
    public void setBookingRefList(List<BookingRefType> list) {
        bookingRefList = list;
    }

    /** 
     * Get the 'OrderActionContextText' element value. Reference to PADIS codeset REA. When used, provides context for the change being requested.
     * 
     * @return value
     */
    public String getOrderActionContextText() {
        return orderActionContextText;
    }

    /** 
     * Set the 'OrderActionContextText' element value. Reference to PADIS codeset REA. When used, provides context for the change being requested.
     * 
     * @param orderActionContextText
     */
    public void setOrderActionContextText(String orderActionContextText) {
        this.orderActionContextText = orderActionContextText;
    }

    /** 
     * Get the 'OrderRefID' element value. Reference to existing Order to which the Seller wants to add, udpate, delete an OrderItem.
     * 
     * @return value
     */
    public String getOrderRefID() {
        return orderRefID;
    }

    /** 
     * Set the 'OrderRefID' element value. Reference to existing Order to which the Seller wants to add, udpate, delete an OrderItem.
     * 
     * @param orderRefID
     */
    public void setOrderRefID(String orderRefID) {
        this.orderRefID = orderRefID;
    }

    /** 
     * Get the 'ReshopParameters' element value. Information related to how shopping results should be returned in the response.
     * 
     * @return value
     */
    public ResponseParametersType getReshopParameters() {
        return reshopParameters;
    }

    /** 
     * Set the 'ReshopParameters' element value. Information related to how shopping results should be returned in the response.
     * 
     * @param reshopParameters
     */
    public void setReshopParameters(ResponseParametersType reshopParameters) {
        this.reshopParameters = reshopParameters;
    }

    /** 
     * Get the 'UpdateOrder' element value. Option to Reshop or Reprice an Order.
     * 
     * @return value
     */
    public UpdateOrderType getUpdateOrder() {
        return updateOrder;
    }

    /** 
     * Set the 'UpdateOrder' element value. Option to Reshop or Reprice an Order.
     * 
     * @param updateOrder
     */
    public void setUpdateOrder(UpdateOrderType updateOrder) {
        this.updateOrder = updateOrder;
    }
}
