
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderReshop.rq;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * The Identification and contact information of a party purchasing goods or services as registered with a Purchase Tax.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/2015/00/2019.1/IATA_OrderReshopRQ" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="SalesTaxRegistrationType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="CityName" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="CountryCode" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="CountryDialingCode" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="CountrySubDivisionName" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="EmailAddressText" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="PhoneNumber" minOccurs="0" maxOccurs="2"/>
 *     &lt;xs:element type="xs:string" name="PostalCode" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="SalesTaxRegistrationID" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="StreetText" minOccurs="0" maxOccurs="2"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class SalesTaxRegistrationType implements Serializable
{
    private String cityName;
    private String countryCode;
    private String countryDialingCode;
    private String countrySubDivisionName;
    private String emailAddressText;
    private List<String> phoneNumberList = new ArrayList<String>();
    private String postalCode;
    private String salesTaxRegistrationID;
    private List<String> streetTextList = new ArrayList<String>();

    /** 
     * Get the 'CityName' element value. The name, expressed as text, of the city, town or village.
     * 
     * @return value
     */
    public String getCityName() {
        return cityName;
    }

    /** 
     * Set the 'CityName' element value. The name, expressed as text, of the city, town or village.
     * 
     * @param cityName
     */
    public void setCityName(String cityName) {
        this.cityName = cityName;
    }

    /** 
     * Get the 'CountryCode' element value. ISO Country Code (can be extended by bilateral agreement in case of exceptions, e.g. Kosovo). Examples: US, FR.
     * 
     * @return value
     */
    public String getCountryCode() {
        return countryCode;
    }

    /** 
     * Set the 'CountryCode' element value. ISO Country Code (can be extended by bilateral agreement in case of exceptions, e.g. Kosovo). Examples: US, FR.
     * 
     * @param countryCode
     */
    public void setCountryCode(String countryCode) {
        this.countryCode = countryCode;
    }

    /** 
     * Get the 'CountryDialingCode' element value. Numeric telephone dialingÂ prefixes for the memberÂ countries of the International Telecommunication Union (ITU).
     * 
     * @return value
     */
    public String getCountryDialingCode() {
        return countryDialingCode;
    }

    /** 
     * Set the 'CountryDialingCode' element value. Numeric telephone dialingÂ prefixes for the memberÂ countries of the International Telecommunication Union (ITU).
     * 
     * @param countryDialingCode
     */
    public void setCountryDialingCode(String countryDialingCode) {
        this.countryDialingCode = countryDialingCode;
    }

    /** 
     * Get the 'CountrySubDivisionName' element value. The name, expressed as text, of the sub-division of a country.
     * 
     * @return value
     */
    public String getCountrySubDivisionName() {
        return countrySubDivisionName;
    }

    /** 
     * Set the 'CountrySubDivisionName' element value. The name, expressed as text, of the sub-division of a country.
     * 
     * @param countrySubDivisionName
     */
    public void setCountrySubDivisionName(String countrySubDivisionName) {
        this.countrySubDivisionName = countrySubDivisionName;
    }

    /** 
     * Get the 'EmailAddressText' element value. The email address which should be used for contact purposes.
     * 
     * @return value
     */
    public String getEmailAddressText() {
        return emailAddressText;
    }

    /** 
     * Set the 'EmailAddressText' element value. The email address which should be used for contact purposes.
     * 
     * @param emailAddressText
     */
    public void setEmailAddressText(String emailAddressText) {
        this.emailAddressText = emailAddressText;
    }

    /** 
     * Get the list of 'PhoneNumber' element items. Phone number text. Examples: +1 999-999-9999 ext 1234,  617-9976 Note: This may be a simple, un-structured phone number, such as +01 999-999-9999 ext 1234 or combined with the additional attributes to create a structured phone number.
     * 
     * @return list
     */
    public List<String> getPhoneNumberList() {
        return phoneNumberList;
    }

    /** 
     * Set the list of 'PhoneNumber' element items. Phone number text. Examples: +1 999-999-9999 ext 1234,  617-9976 Note: This may be a simple, un-structured phone number, such as +01 999-999-9999 ext 1234 or combined with the additional attributes to create a structured phone number.
     * 
     * @param list
     */
    public void setPhoneNumberList(List<String> list) {
        phoneNumberList = list;
    }

    /** 
     * Get the 'PostalCode' element value. Postal code. Examples: 11001, 11001-2345
     * 
     * @return value
     */
    public String getPostalCode() {
        return postalCode;
    }

    /** 
     * Set the 'PostalCode' element value. Postal code. Examples: 11001, 11001-2345
     * 
     * @param postalCode
     */
    public void setPostalCode(String postalCode) {
        this.postalCode = postalCode;
    }

    /** 
     * Get the 'SalesTaxRegistrationID' element value. Registered identifier of the business purchasing the goods and services.  For example, a GST number in India XX.
     * 
     * @return value
     */
    public String getSalesTaxRegistrationID() {
        return salesTaxRegistrationID;
    }

    /** 
     * Set the 'SalesTaxRegistrationID' element value. Registered identifier of the business purchasing the goods and services.  For example, a GST number in India XX.
     * 
     * @param salesTaxRegistrationID
     */
    public void setSalesTaxRegistrationID(String salesTaxRegistrationID) {
        this.salesTaxRegistrationID = salesTaxRegistrationID;
    }

    /** 
     * Get the list of 'StreetText' element items. Street name and number. Examples: Main Street, 100 Main Street
     * 
     * @return list
     */
    public List<String> getStreetTextList() {
        return streetTextList;
    }

    /** 
     * Set the list of 'StreetText' element items. Street name and number. Examples: Main Street, 100 Main Street
     * 
     * @param list
     */
    public void setStreetTextList(List<String> list) {
        streetTextList = list;
    }
}
