
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderReshop.rq;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * A sitting place for a passenger or crew in a cabin compartment on a transport vehicle.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/2015/00/2019.1/IATA_OrderReshopRQ" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="SeatType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="CharacteristicCode" minOccurs="0" maxOccurs="99"/>
 *     &lt;xs:element type="xs:string" name="ColumnID" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:SeatProfileType" name="SeatProfile" minOccurs="0" maxOccurs="unbounded"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class SeatType implements Serializable
{
    private List<String> characteristicCodeList = new ArrayList<String>();
    private String columnID;
    private List<SeatProfileType> seatProfileList = new ArrayList<SeatProfileType>();

    /** 
     * Get the list of 'CharacteristicCode' element items. Seat characteristic/property code (e.g. A - Aisle Seat, W - Window Seat, etc.).
     * 
     * @return list
     */
    public List<String> getCharacteristicCodeList() {
        return characteristicCodeList;
    }

    /** 
     * Set the list of 'CharacteristicCode' element items. Seat characteristic/property code (e.g. A - Aisle Seat, W - Window Seat, etc.).
     * 
     * @param list
     */
    public void setCharacteristicCodeList(List<String> list) {
        characteristicCodeList = list;
    }

    /** 
     * Get the 'ColumnID' element value. Alphabetic character identifying a seat within a row.
     * 
     * @return value
     */
    public String getColumnID() {
        return columnID;
    }

    /** 
     * Set the 'ColumnID' element value. Alphabetic character identifying a seat within a row.
     * 
     * @param columnID
     */
    public void setColumnID(String columnID) {
        this.columnID = columnID;
    }

    /** 
     * Get the list of 'SeatProfile' element items. Airline defined group of seats sharing common characteristics.
     * 
     * @return list
     */
    public List<SeatProfileType> getSeatProfileList() {
        return seatProfileList;
    }

    /** 
     * Set the list of 'SeatProfile' element items. Airline defined group of seats sharing common characteristics.
     * 
     * @param list
     */
    public void setSeatProfileList(List<SeatProfileType> list) {
        seatProfileList = list;
    }
}
