
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderReshop.rq;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Further qualifies the flight request by influencing which results are returned in the shopping response, including preferred or required criteria.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/2015/00/2019.1/IATA_OrderReshopRQ" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ShoppingCriteriaType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:AllianceCriteriaType" name="AllianceCriteria" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:BaggagePricingCriteriaType" name="BaggagePricingCriteria" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:CabinTypeType" name="CabinTypeCriteria" minOccurs="0" maxOccurs="unbounded"/>
 *     &lt;xs:element type="ns:CarrierCriteriaType" name="CarrierCriteria" minOccurs="0" maxOccurs="unbounded"/>
 *     &lt;xs:element type="ns:ConnectionCriteriaType" name="ConnectionCriteria" minOccurs="0" maxOccurs="unbounded"/>
 *     &lt;xs:element type="ns:ExistingOrderCriteriaType" name="ExistingOrderCriteria" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:FareCriteriaType" name="FareCriteria" minOccurs="0" maxOccurs="unbounded"/>
 *     &lt;xs:element type="ns:FlightCriteriaType" name="FlightCriteria" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:PaymentCardCriteriaType" name="PaymentCardCriteria" minOccurs="0" maxOccurs="unbounded"/>
 *     &lt;xs:element type="ns:PaymentMethodCriteriaType" name="PaymentMethodCriteria" minOccurs="0" maxOccurs="unbounded"/>
 *     &lt;xs:element type="ns:PricingMethodCriteriaType" name="PricingMethodCriteria" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:ProgramCriteriaType" name="ProgramCriteria" minOccurs="0" maxOccurs="unbounded"/>
 *     &lt;xs:element type="ns:PromotionType" name="PromotionCriteria" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:SeatType" name="SeatCriteria" minOccurs="0" maxOccurs="unbounded"/>
 *     &lt;xs:element type="ns:SegmentDurationCriteriaType" name="SegmentDurationCriteria" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:ServiceCriteriaType" name="ServiceCriteria" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:SpecialServiceType" name="SpecialNeedsCriteria" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:TripPurposeCodeContentType" name="TripPurposeCode" minOccurs="0" maxOccurs="1"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class ShoppingCriteriaType implements Serializable
{
    private AllianceCriteriaType allianceCriteria;
    private BaggagePricingCriteriaType baggagePricingCriteria;
    private List<CabinTypeType> cabinTypeCriteriaList = new ArrayList<CabinTypeType>();
    private List<CarrierCriteriaType> carrierCriteriaList = new ArrayList<CarrierCriteriaType>();
    private List<ConnectionCriteriaType> connectionCriteriaList = new ArrayList<ConnectionCriteriaType>();
    private ExistingOrderCriteriaType existingOrderCriteria;
    private List<FareCriteriaType> fareCriteriaList = new ArrayList<FareCriteriaType>();
    private FlightCriteriaType flightCriteria;
    private List<PaymentCardCriteriaType> paymentCardCriteriaList = new ArrayList<PaymentCardCriteriaType>();
    private List<PaymentMethodCriteriaType> paymentMethodCriteriaList = new ArrayList<PaymentMethodCriteriaType>();
    private PricingMethodCriteriaType pricingMethodCriteria;
    private List<ProgramCriteriaType> programCriteriaList = new ArrayList<ProgramCriteriaType>();
    private PromotionType promotionCriteria;
    private List<SeatType> seatCriteriaList = new ArrayList<SeatType>();
    private SegmentDurationCriteriaType segmentDurationCriteria;
    private ServiceCriteriaType serviceCriteria;
    private SpecialServiceType specialNeedsCriteria;
    private TripPurposeCodeContentType tripPurposeCode;

    /** 
     * Get the 'AllianceCriteria' element value. Filtering criteria based on Alliance.
     * 
     * @return value
     */
    public AllianceCriteriaType getAllianceCriteria() {
        return allianceCriteria;
    }

    /** 
     * Set the 'AllianceCriteria' element value. Filtering criteria based on Alliance.
     * 
     * @param allianceCriteria
     */
    public void setAllianceCriteria(AllianceCriteriaType allianceCriteria) {
        this.allianceCriteria = allianceCriteria;
    }

    /** 
     * Get the 'BaggagePricingCriteria' element value. Baggage pricing specific filter criteria for shopping requests, including baggage type, charges, and settlement information.
     * 
     * @return value
     */
    public BaggagePricingCriteriaType getBaggagePricingCriteria() {
        return baggagePricingCriteria;
    }

    /** 
     * Set the 'BaggagePricingCriteria' element value. Baggage pricing specific filter criteria for shopping requests, including baggage type, charges, and settlement information.
     * 
     * @param baggagePricingCriteria
     */
    public void setBaggagePricingCriteria(
            BaggagePricingCriteriaType baggagePricingCriteria) {
        this.baggagePricingCriteria = baggagePricingCriteria;
    }

    /** 
     * Get the list of 'CabinTypeCriteria' element items. Type of compartment of an aircraft, offering specific services (e.g. business class, economy).
     * 
     * @return list
     */
    public List<CabinTypeType> getCabinTypeCriteriaList() {
        return cabinTypeCriteriaList;
    }

    /** 
     * Set the list of 'CabinTypeCriteria' element items. Type of compartment of an aircraft, offering specific services (e.g. business class, economy).
     * 
     * @param list
     */
    public void setCabinTypeCriteriaList(List<CabinTypeType> list) {
        cabinTypeCriteriaList = list;
    }

    /** 
     * Get the list of 'CarrierCriteria' element items. Airline preferences for a shopping request.
     * 
     * @return list
     */
    public List<CarrierCriteriaType> getCarrierCriteriaList() {
        return carrierCriteriaList;
    }

    /** 
     * Set the list of 'CarrierCriteria' element items. Airline preferences for a shopping request.
     * 
     * @param list
     */
    public void setCarrierCriteriaList(List<CarrierCriteriaType> list) {
        carrierCriteriaList = list;
    }

    /** 
     * Get the list of 'ConnectionCriteria' element items. Customer's requested connection information.
     * 
     * @return list
     */
    public List<ConnectionCriteriaType> getConnectionCriteriaList() {
        return connectionCriteriaList;
    }

    /** 
     * Set the list of 'ConnectionCriteria' element items. Customer's requested connection information.
     * 
     * @param list
     */
    public void setConnectionCriteriaList(List<ConnectionCriteriaType> list) {
        connectionCriteriaList = list;
    }

    /** 
     * Get the 'ExistingOrderCriteria' element value. References to Orders that were created from Offers that have already been purchased, booked and/or are being held for a Passenger.
     * 
     * @return value
     */
    public ExistingOrderCriteriaType getExistingOrderCriteria() {
        return existingOrderCriteria;
    }

    /** 
     * Set the 'ExistingOrderCriteria' element value. References to Orders that were created from Offers that have already been purchased, booked and/or are being held for a Passenger.
     * 
     * @param existingOrderCriteria
     */
    public void setExistingOrderCriteria(
            ExistingOrderCriteriaType existingOrderCriteria) {
        this.existingOrderCriteria = existingOrderCriteria;
    }

    /** 
     * Get the list of 'FareCriteria' element items. Fare criteria used to filter shopping results.
     * 
     * @return list
     */
    public List<FareCriteriaType> getFareCriteriaList() {
        return fareCriteriaList;
    }

    /** 
     * Set the list of 'FareCriteria' element items. Fare criteria used to filter shopping results.
     * 
     * @param list
     */
    public void setFareCriteriaList(List<FareCriteriaType> list) {
        fareCriteriaList = list;
    }

    /** 
     * Get the 'FlightCriteria' element value. Flight filter criteria including aircraft features, Cabin Type, RBD, and Tail Number.
     * 
     * @return value
     */
    public FlightCriteriaType getFlightCriteria() {
        return flightCriteria;
    }

    /** 
     * Set the 'FlightCriteria' element value. Flight filter criteria including aircraft features, Cabin Type, RBD, and Tail Number.
     * 
     * @param flightCriteria
     */
    public void setFlightCriteria(FlightCriteriaType flightCriteria) {
        this.flightCriteria = flightCriteria;
    }

    /** 
     * Get the list of 'PaymentCardCriteria' element items. Requested card issuer type and identification number.
     * 
     * @return list
     */
    public List<PaymentCardCriteriaType> getPaymentCardCriteriaList() {
        return paymentCardCriteriaList;
    }

    /** 
     * Set the list of 'PaymentCardCriteria' element items. Requested card issuer type and identification number.
     * 
     * @param list
     */
    public void setPaymentCardCriteriaList(List<PaymentCardCriteriaType> list) {
        paymentCardCriteriaList = list;
    }

    /** 
     * Get the list of 'PaymentMethodCriteria' element items. A form of procedure for the payment of goods or services, plus any transactional information specific to the payment method other than the amount.
     * 
     * @return list
     */
    public List<PaymentMethodCriteriaType> getPaymentMethodCriteriaList() {
        return paymentMethodCriteriaList;
    }

    /** 
     * Set the list of 'PaymentMethodCriteria' element items. A form of procedure for the payment of goods or services, plus any transactional information specific to the payment method other than the amount.
     * 
     * @param list
     */
    public void setPaymentMethodCriteriaList(
            List<PaymentMethodCriteriaType> list) {
        paymentMethodCriteriaList = list;
    }

    /** 
     * Get the 'PricingMethodCriteria' element value. Contains information to identify how reservation was re-priced to obtain best published fare (Eg. best fare in same cabin, best fare in all cabins, other parameters to select best fare).
     * 
     * @return value
     */
    public PricingMethodCriteriaType getPricingMethodCriteria() {
        return pricingMethodCriteria;
    }

    /** 
     * Set the 'PricingMethodCriteria' element value. Contains information to identify how reservation was re-priced to obtain best published fare (Eg. best fare in same cabin, best fare in all cabins, other parameters to select best fare).
     * 
     * @param pricingMethodCriteria
     */
    public void setPricingMethodCriteria(
            PricingMethodCriteriaType pricingMethodCriteria) {
        this.pricingMethodCriteria = pricingMethodCriteria;
    }

    /** 
     * Get the list of 'ProgramCriteria' element items. Filtering criteria based on discount programs.
     * 
     * @return list
     */
    public List<ProgramCriteriaType> getProgramCriteriaList() {
        return programCriteriaList;
    }

    /** 
     * Set the list of 'ProgramCriteria' element items. Filtering criteria based on discount programs.
     * 
     * @param list
     */
    public void setProgramCriteriaList(List<ProgramCriteriaType> list) {
        programCriteriaList = list;
    }

    /** 
     * Get the 'PromotionCriteria' element value. Information related to publicizing  a product, organization, or venture so as to increase sales or public awareness.
     * 
     * @return value
     */
    public PromotionType getPromotionCriteria() {
        return promotionCriteria;
    }

    /** 
     * Set the 'PromotionCriteria' element value. Information related to publicizing  a product, organization, or venture so as to increase sales or public awareness.
     * 
     * @param promotionCriteria
     */
    public void setPromotionCriteria(PromotionType promotionCriteria) {
        this.promotionCriteria = promotionCriteria;
    }

    /** 
     * Get the list of 'SeatCriteria' element items. A sitting place for a passenger or crew in a cabin compartment on a transport vehicle.
     * 
     * @return list
     */
    public List<SeatType> getSeatCriteriaList() {
        return seatCriteriaList;
    }

    /** 
     * Set the list of 'SeatCriteria' element items. A sitting place for a passenger or crew in a cabin compartment on a transport vehicle.
     * 
     * @param list
     */
    public void setSeatCriteriaList(List<SeatType> list) {
        seatCriteriaList = list;
    }

    /** 
     * Get the 'SegmentDurationCriteria' element value. Total segment travel time preferences.
     * 
     * @return value
     */
    public SegmentDurationCriteriaType getSegmentDurationCriteria() {
        return segmentDurationCriteria;
    }

    /** 
     * Set the 'SegmentDurationCriteria' element value. Total segment travel time preferences.
     * 
     * @param segmentDurationCriteria
     */
    public void setSegmentDurationCriteria(
            SegmentDurationCriteriaType segmentDurationCriteria) {
        this.segmentDurationCriteria = segmentDurationCriteria;
    }

    /** 
     * Get the 'ServiceCriteria' element value. Group and subgroup code(s) that specify the requested categories of Optional Services to be returned in the results.
     * 
     * @return value
     */
    public ServiceCriteriaType getServiceCriteria() {
        return serviceCriteria;
    }

    /** 
     * Set the 'ServiceCriteria' element value. Group and subgroup code(s) that specify the requested categories of Optional Services to be returned in the results.
     * 
     * @param serviceCriteria
     */
    public void setServiceCriteria(ServiceCriteriaType serviceCriteria) {
        this.serviceCriteria = serviceCriteria;
    }

    /** 
     * Get the 'SpecialNeedsCriteria' element value. Passenger Special Needs Attributes.

    Notes:
    1. Supports specification of Traveler special needs in both IATA SSR encoding and non-IATA encoding.

    2. Special Needs may be associated to individual Travelers but will apply to ALL Travelers if no associations are specified.

    3. Special Needs may be associated to flight segments but will apply to ALL flight segments if no associations are specified.
     * 
     * @return value
     */
    public SpecialServiceType getSpecialNeedsCriteria() {
        return specialNeedsCriteria;
    }

    /** 
     * Set the 'SpecialNeedsCriteria' element value. Passenger Special Needs Attributes.

    Notes:
    1. Supports specification of Traveler special needs in both IATA SSR encoding and non-IATA encoding.

    2. Special Needs may be associated to individual Travelers but will apply to ALL Travelers if no associations are specified.

    3. Special Needs may be associated to flight segments but will apply to ALL flight segments if no associations are specified.
     * 
     * @param specialNeedsCriteria
     */
    public void setSpecialNeedsCriteria(SpecialServiceType specialNeedsCriteria) {
        this.specialNeedsCriteria = specialNeedsCriteria;
    }

    /** 
     * Get the 'TripPurposeCode' element value. Trip purpose information (e.g. Business, Leisure, etc.).
     * 
     * @return value
     */
    public TripPurposeCodeContentType getTripPurposeCode() {
        return tripPurposeCode;
    }

    /** 
     * Set the 'TripPurposeCode' element value. Trip purpose information (e.g. Business, Leisure, etc.).
     * 
     * @param tripPurposeCode
     */
    public void setTripPurposeCode(TripPurposeCodeContentType tripPurposeCode) {
        this.tripPurposeCode = tripPurposeCode;
    }
}
