
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderReshop.rq;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * The customer's requested Station criteria.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/2015/00/2019.1/IATA_OrderReshopRQ" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="StationCriteriaType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:PrefLevelType" name="PrefLevel" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:StationType" name="Station" minOccurs="0" maxOccurs="unbounded"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class StationCriteriaType implements Serializable
{
    private PrefLevelType prefLevel;
    private List<StationType> stationList = new ArrayList<StationType>();

    /** 
     * Get the 'PrefLevel' element value. Information supporting a preference including preference level code (e.g. Preferred, Exclude, etc.).
     * 
     * @return value
     */
    public PrefLevelType getPrefLevel() {
        return prefLevel;
    }

    /** 
     * Set the 'PrefLevel' element value. Information supporting a preference including preference level code (e.g. Preferred, Exclude, etc.).
     * 
     * @param prefLevel
     */
    public void setPrefLevel(PrefLevelType prefLevel) {
        this.prefLevel = prefLevel;
    }

    /** 
     * Get the list of 'Station' element items. Location or facility where air or surface transportation originates, stops and/or terminates, and where passengers and/or cargo can be taken on or off.
     * 
     * @return list
     */
    public List<StationType> getStationList() {
        return stationList;
    }

    /** 
     * Set the list of 'Station' element items. Location or facility where air or surface transportation originates, stops and/or terminates, and where passengers and/or cargo can be taken on or off.
     * 
     * @param list
     */
    public void setStationList(List<StationType> list) {
        stationList = list;
    }
}
