
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderReshop.rq;

import java.io.Serializable;

/** 
 * Option to Reshop or Reprice an Order.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/2015/00/2019.1/IATA_OrderReshopRQ" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="UpdateOrderType">
 *   &lt;xs:choice>
 *     &lt;xs:element type="ns:RepriceOrderType" name="RepriceOrder" minOccurs="1" maxOccurs="1"/>
 *     &lt;xs:element type="ns:ReshopOrderType" name="ReshopOrder" minOccurs="1" maxOccurs="1"/>
 *   &lt;/xs:choice>
 * &lt;/xs:complexType>
 * </pre>
 */
public class UpdateOrderType implements Serializable
{
    private int choiceSelect = -1;
    private static final int REPRICE_ORDER_CHOICE = 0;
    private static final int RESHOP_ORDER_CHOICE = 1;
    private RepriceOrderType repriceOrder;
    private ReshopOrderType reshopOrder;

    private void setChoiceSelect(int choice) {
        if (choiceSelect == -1) {
            choiceSelect = choice;
        } else if (choiceSelect != choice) {
            throw new IllegalStateException(
                    "Need to call clearChoiceSelect() before changing existing choice");
        }
    }

    /** 
     * Clear the choice selection.
     */
    public void clearChoiceSelect() {
        choiceSelect = -1;
    }

    /** 
     * Check if RepriceOrder is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifRepriceOrder() {
        return choiceSelect == REPRICE_ORDER_CHOICE;
    }

    /** 
     * Get the 'RepriceOrder' element value. Function to reprice entire Order (if only OrderID is supplied within Request) or Specific OrderItems (if defined in nested OrderItem elements)
     * 
     * @return value
     */
    public RepriceOrderType getRepriceOrder() {
        return repriceOrder;
    }

    /** 
     * Set the 'RepriceOrder' element value. Function to reprice entire Order (if only OrderID is supplied within Request) or Specific OrderItems (if defined in nested OrderItem elements)
     * 
     * @param repriceOrder
     */
    public void setRepriceOrder(RepriceOrderType repriceOrder) {
        setChoiceSelect(REPRICE_ORDER_CHOICE);
        this.repriceOrder = repriceOrder;
    }

    /** 
     * Check if ReshopOrder is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifReshopOrder() {
        return choiceSelect == RESHOP_ORDER_CHOICE;
    }

    /** 
     * Get the 'ReshopOrder' element value. Function used to reshop items within an Order (e.g. adding ancillaries, canceling Order Items, or replacing Order Items.
     * 
     * @return value
     */
    public ReshopOrderType getReshopOrder() {
        return reshopOrder;
    }

    /** 
     * Set the 'ReshopOrder' element value. Function used to reshop items within an Order (e.g. adding ancillaries, canceling Order Items, or replacing Order Items.
     * 
     * @param reshopOrder
     */
    public void setReshopOrder(ReshopOrderType reshopOrder) {
        setChoiceSelect(RESHOP_ORDER_CHOICE);
        this.reshopOrder = reshopOrder;
    }
}
