
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderReshop.rs;

import java.io.Serializable;

/** 
 * Contains one Service (excluding flights) or Service Bundle which is priced per unit. A La Carte Offer Items are optional, and the quantities of these can be selected for any of the eligible passengers and segments.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/2015/00/2019.1/IATA_OrderReshopRS" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ALaCarteOfferItemType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:EligibilityType" name="Eligibility" minOccurs="1" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="OfferItemID" minOccurs="1" maxOccurs="1"/>
 *     &lt;xs:element type="ns:PaymentTimeLimitType" name="PaymentTimeLimit" minOccurs="0"/>
 *     &lt;xs:element type="ns:DateTimeType" name="PriceGuaranteeTimeLimitDateTime" minOccurs="0"/>
 *     &lt;xs:element type="ns:Service1Type" name="Service" minOccurs="1" maxOccurs="1"/>
 *     &lt;xs:element type="ns:PriceType" name="UnitPrice" minOccurs="1" maxOccurs="1"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class ALaCarteOfferItemType implements Serializable
{
    private EligibilityType eligibility;
    private String offerItemID;
    private PaymentTimeLimitType paymentTimeLimit;
    private DateTimeType priceGuaranteeTimeLimitDateTime;
    private Service1Type service;
    private PriceType unitPrice;

    /** 
     * Get the 'Eligibility' element value. Refers to the Passengers, Price class or segments for which this offer item is eligible.
     * 
     * @return value
     */
    public EligibilityType getEligibility() {
        return eligibility;
    }

    /** 
     * Set the 'Eligibility' element value. Refers to the Passengers, Price class or segments for which this offer item is eligible.
     * 
     * @param eligibility
     */
    public void setEligibility(EligibilityType eligibility) {
        this.eligibility = eligibility;
    }

    /** 
     * Get the 'OfferItemID' element value. Uniquely Identifies an Offer within the context of one message.
     * 
     * @return value
     */
    public String getOfferItemID() {
        return offerItemID;
    }

    /** 
     * Set the 'OfferItemID' element value. Uniquely Identifies an Offer within the context of one message.
     * 
     * @param offerItemID
     */
    public void setOfferItemID(String offerItemID) {
        this.offerItemID = offerItemID;
    }

    /** 
     * Get the 'PaymentTimeLimit' element value. This node is used to indicate by when payment commitment must be received for confirmed Order Item in an Order.

    To indicate instant payment, the duration field should be populated with a value of 0.

    If no value is returned, then no advice has been given.
     * 
     * @return value
     */
    public PaymentTimeLimitType getPaymentTimeLimit() {
        return paymentTimeLimit;
    }

    /** 
     * Set the 'PaymentTimeLimit' element value. This node is used to indicate by when payment commitment must be received for confirmed Order Item in an Order.

    To indicate instant payment, the duration field should be populated with a value of 0.

    If no value is returned, then no advice has been given.
     * 
     * @param paymentTimeLimit
     */
    public void setPaymentTimeLimit(PaymentTimeLimitType paymentTimeLimit) {
        this.paymentTimeLimit = paymentTimeLimit;
    }

    /** 
     * Get the 'PriceGuaranteeTimeLimitDateTime' element value. The length of time the price of an offer item is guaranteed.  In the absence of the price guarantee time limit, the price is not guaranteed.  Upon expiry, the price may no longer be guaranteed and either a new shopping process should begin, or the offer should be repriced resulting in a new Offer.    Should the price guarantee time limit extend beyond Order creation (or change), the remaining length of time persists into the corresponding Order Item.  At Order creation (or change) the airline can increase the remaining length of time beyond the original time limit should they wish to.  Note: Where a price guarantee time limit is applied, there is no guarantee that related inventory is guaranteed by the airline.
     * 
     * @return value
     */
    public DateTimeType getPriceGuaranteeTimeLimitDateTime() {
        return priceGuaranteeTimeLimitDateTime;
    }

    /** 
     * Set the 'PriceGuaranteeTimeLimitDateTime' element value. The length of time the price of an offer item is guaranteed.  In the absence of the price guarantee time limit, the price is not guaranteed.  Upon expiry, the price may no longer be guaranteed and either a new shopping process should begin, or the offer should be repriced resulting in a new Offer.    Should the price guarantee time limit extend beyond Order creation (or change), the remaining length of time persists into the corresponding Order Item.  At Order creation (or change) the airline can increase the remaining length of time beyond the original time limit should they wish to.  Note: Where a price guarantee time limit is applied, there is no guarantee that related inventory is guaranteed by the airline.
     * 
     * @param priceGuaranteeTimeLimitDateTime
     */
    public void setPriceGuaranteeTimeLimitDateTime(
            DateTimeType priceGuaranteeTimeLimitDateTime) {
        this.priceGuaranteeTimeLimitDateTime = priceGuaranteeTimeLimitDateTime;
    }

    /** 
     * Get the 'Service' element value. The instance of a specific flight or Service Definition as it has been offered (and eventually ordered and consumed) in the context of a specific Offer and/or Order.
     * 
     * @return value
     */
    public Service1Type getService() {
        return service;
    }

    /** 
     * Set the 'Service' element value. The instance of a specific flight or Service Definition as it has been offered (and eventually ordered and consumed) in the context of a specific Offer and/or Order.
     * 
     * @param service
     */
    public void setService(Service1Type service) {
        this.service = service;
    }

    /** 
     * Get the 'UnitPrice' element value. The amount of money expected, required, or given in payment for something.
     * 
     * @return value
     */
    public PriceType getUnitPrice() {
        return unitPrice;
    }

    /** 
     * Set the 'UnitPrice' element value. The amount of money expected, required, or given in payment for something.
     * 
     * @param unitPrice
     */
    public void setUnitPrice(PriceType unitPrice) {
        this.unitPrice = unitPrice;
    }
}
