
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderReshop.rs;

import java.io.Serializable;

/** 
 * Form of payment which utilizes a previously issued accountable travel document (ticket, EMD, coupon, etc.) which has an outstanding credit value.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/2015/00/2019.1/IATA_OrderReshopRS" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AccountableDocType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="DocType" minOccurs="1" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="TicketID" minOccurs="0" maxOccurs="1"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class AccountableDocType implements Serializable
{
    private String docType;
    private String ticketID;

    /** 
     * Get the 'DocType' element value. Type of Accountable Document e.g. T, E and M or E-ticket, EMD, MCO 
     * 
     * @return value
     */
    public String getDocType() {
        return docType;
    }

    /** 
     * Set the 'DocType' element value. Type of Accountable Document e.g. T, E and M or E-ticket, EMD, MCO 
     * 
     * @param docType
     */
    public void setDocType(String docType) {
        this.docType = docType;
    }

    /** 
     * Get the 'TicketID' element value. MCO, Ticket or EMD reference number, indicating a previously issued document
     * 
     * @return value
     */
    public String getTicketID() {
        return ticketID;
    }

    /** 
     * Set the 'TicketID' element value. MCO, Ticket or EMD reference number, indicating a previously issued document
     * 
     * @param ticketID
     */
    public void setTicketID(String ticketID) {
        this.ticketID = ticketID;
    }
}
