
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderReshop.rs;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * The amount of checked or carry-on luggage the airline will allow per passenger.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/2015/00/2019.1/IATA_OrderReshopRS" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="BaggageAllowanceType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="ApplicableBagText" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="ApplicablePartyText" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="BaggageAllowanceID" minOccurs="1" maxOccurs="1"/>
 *     &lt;xs:element type="ns:BDC_Type" name="BDC" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="DescText" minOccurs="0" maxOccurs="99"/>
 *     &lt;xs:element type="ns:DimensionAllowanceType" name="DimensionAllowance" minOccurs="0" maxOccurs="unbounded"/>
 *     &lt;xs:element type="ns:PieceAllowanceType" name="PieceAllowance" minOccurs="0" maxOccurs="unbounded"/>
 *     &lt;xs:element type="xs:string" name="RFISC" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:BaggageTypeCodeContentType" name="TypeCode" minOccurs="1" maxOccurs="1"/>
 *     &lt;xs:element type="ns:WeightAllowanceType" name="WeightAllowance" minOccurs="0" maxOccurs="unbounded"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class BaggageAllowanceType implements Serializable
{
    private String applicableBagText;
    private String applicablePartyText;
    private String baggageAllowanceID;
    private BDCType BDC;
    private List<String> descTextList = new ArrayList<String>();
    private List<DimensionAllowanceType> dimensionAllowanceList = new ArrayList<DimensionAllowanceType>();
    private List<PieceAllowanceType> pieceAllowanceList = new ArrayList<PieceAllowanceType>();
    private String RFISC;
    private BaggageTypeCodeContentType typeCode;
    private List<WeightAllowanceType> weightAllowanceList = new ArrayList<WeightAllowanceType>();

    /** 
     * Get the 'ApplicableBagText' element value. Applicable bag type.  Examples: Carry-On, 1st Checked Bag, 2nd Checked Bag
     * 
     * @return value
     */
    public String getApplicableBagText() {
        return applicableBagText;
    }

    /** 
     * Set the 'ApplicableBagText' element value. Applicable bag type.  Examples: Carry-On, 1st Checked Bag, 2nd Checked Bag
     * 
     * @param applicableBagText
     */
    public void setApplicableBagText(String applicableBagText) {
        this.applicableBagText = applicableBagText;
    }

    /** 
     * Get the 'ApplicablePartyText' element value. Baggage weight restriction application.  Examples: Party, Traveler. Party applies to all Travelers.
     * 
     * @return value
     */
    public String getApplicablePartyText() {
        return applicablePartyText;
    }

    /** 
     * Set the 'ApplicablePartyText' element value. Baggage weight restriction application.  Examples: Party, Traveler. Party applies to all Travelers.
     * 
     * @param applicablePartyText
     */
    public void setApplicablePartyText(String applicablePartyText) {
        this.applicablePartyText = applicablePartyText;
    }

    /** 
     * Get the 'BaggageAllowanceID' element value. Unique identifier of this Baggage Allowance.
     * 
     * @return value
     */
    public String getBaggageAllowanceID() {
        return baggageAllowanceID;
    }

    /** 
     * Set the 'BaggageAllowanceID' element value. Unique identifier of this Baggage Allowance.
     * 
     * @param baggageAllowanceID
     */
    public void setBaggageAllowanceID(String baggageAllowanceID) {
        this.baggageAllowanceID = baggageAllowanceID;
    }

    /** 
     * Get the 'BDC' element value. The carrier whose baggage allowances and charges apply.
     * 
     * @return value
     */
    public BDCType getBDC() {
        return BDC;
    }

    /** 
     * Set the 'BDC' element value. The carrier whose baggage allowances and charges apply.
     * 
     * @param BDC
     */
    public void setBDC(BDCType BDC) {
        this.BDC = BDC;
    }

    /** 
     * Get the list of 'DescText' element items. Baggage Allowance description and additional information.
     * 
     * @return list
     */
    public List<String> getDescTextList() {
        return descTextList;
    }

    /** 
     * Set the list of 'DescText' element items. Baggage Allowance description and additional information.
     * 
     * @param list
     */
    public void setDescTextList(List<String> list) {
        descTextList = list;
    }

    /** 
     * Get the list of 'DimensionAllowance' element items. Baggage dimension allowance with application information.
     * 
     * @return list
     */
    public List<DimensionAllowanceType> getDimensionAllowanceList() {
        return dimensionAllowanceList;
    }

    /** 
     * Set the list of 'DimensionAllowance' element items. Baggage dimension allowance with application information.
     * 
     * @param list
     */
    public void setDimensionAllowanceList(List<DimensionAllowanceType> list) {
        dimensionAllowanceList = list;
    }

    /** 
     * Get the list of 'PieceAllowance' element items. Defines the maximum number of each allowable baggage type.
     * 
     * @return list
     */
    public List<PieceAllowanceType> getPieceAllowanceList() {
        return pieceAllowanceList;
    }

    /** 
     * Set the list of 'PieceAllowance' element items. Defines the maximum number of each allowable baggage type.
     * 
     * @param list
     */
    public void setPieceAllowanceList(List<PieceAllowanceType> list) {
        pieceAllowanceList = list;
    }

    /** 
     * Get the 'RFISC' element value. Reason For Issuance Sub Code. Examples: 0CC (First Checked Bag) 0B1 (In-flight Entertainment) 0BX (Lounge)
     * 
     * @return value
     */
    public String getRFISC() {
        return RFISC;
    }

    /** 
     * Set the 'RFISC' element value. Reason For Issuance Sub Code. Examples: 0CC (First Checked Bag) 0B1 (In-flight Entertainment) 0BX (Lounge)
     * 
     * @param RFISC
     */
    public void setRFISC(String RFISC) {
        this.RFISC = RFISC;
    }

    /** 
     * Get the 'TypeCode' element value. Type of Baggage Allowance.  E.g. Checked or CarryOn.
     * 
     * @return value
     */
    public BaggageTypeCodeContentType getTypeCode() {
        return typeCode;
    }

    /** 
     * Set the 'TypeCode' element value. Type of Baggage Allowance.  E.g. Checked or CarryOn.
     * 
     * @param typeCode
     */
    public void setTypeCode(BaggageTypeCodeContentType typeCode) {
        this.typeCode = typeCode;
    }

    /** 
     * Get the list of 'WeightAllowance' element items. Baggage weight allowance with application information.
     * 
     * @return list
     */
    public List<WeightAllowanceType> getWeightAllowanceList() {
        return weightAllowanceList;
    }

    /** 
     * Set the list of 'WeightAllowance' element items. Baggage weight allowance with application information.
     * 
     * @param list
     */
    public void setWeightAllowanceList(List<WeightAllowanceType> list) {
        weightAllowanceList = list;
    }
}
