
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderReshop.rs;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Optional service booking instructions to include SSR, OSI and upgrade Method.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/2015/00/2019.1/IATA_OrderReshopRS" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="BookingInstructionsType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="MethodText" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="OtherServiceInfoText" minOccurs="0" maxOccurs="unbounded"/>
 *     &lt;xs:element type="ns:SpecialServiceType" name="SpecialService" minOccurs="0" maxOccurs="unbounded"/>
 *     &lt;xs:element type="xs:string" name="UpgradeMethodCode" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="UpgradeNewClassCode" minOccurs="0" maxOccurs="1"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class BookingInstructionsType implements Serializable
{
    private String methodText;
    private List<String> otherServiceInfoTextList = new ArrayList<String>();
    private List<SpecialServiceType> specialServiceList = new ArrayList<SpecialServiceType>();
    private String upgradeMethodCode;
    private String upgradeNewClassCode;

    /** 
     * Get the 'MethodText' element value. PNR booking method. Example: AE (BY SSR - SPECIAL SERVICE REQUEST)  For maximum interoperability, refer to IATA PADIS Code List for data element 9750. Select a code value or enter a value that is bilaterally agreed upon between trading partners.
     * 
     * @return value
     */
    public String getMethodText() {
        return methodText;
    }

    /** 
     * Set the 'MethodText' element value. PNR booking method. Example: AE (BY SSR - SPECIAL SERVICE REQUEST)  For maximum interoperability, refer to IATA PADIS Code List for data element 9750. Select a code value or enter a value that is bilaterally agreed upon between trading partners.
     * 
     * @param methodText
     */
    public void setMethodText(String methodText) {
        this.methodText = methodText;
    }

    /** 
     * Get the list of 'OtherServiceInfoText' element items. Other service information (OSI) text. Example: PAX VIP MEMBER OF PARLIAMENT
     * 
     * @return list
     */
    public List<String> getOtherServiceInfoTextList() {
        return otherServiceInfoTextList;
    }

    /** 
     * Set the list of 'OtherServiceInfoText' element items. Other service information (OSI) text. Example: PAX VIP MEMBER OF PARLIAMENT
     * 
     * @param list
     */
    public void setOtherServiceInfoTextList(List<String> list) {
        otherServiceInfoTextList = list;
    }

    /** 
     * Get the list of 'SpecialService' element items. Special service information
     * 
     * @return list
     */
    public List<SpecialServiceType> getSpecialServiceList() {
        return specialServiceList;
    }

    /** 
     * Set the list of 'SpecialService' element items. Special service information
     * 
     * @param list
     */
    public void setSpecialServiceList(List<SpecialServiceType> list) {
        specialServiceList = list;
    }

    /** 
     * Get the 'UpgradeMethodCode' element value. Upgrade method. Example: AE (BY SSR - SPECIAL SERVICE REQUEST)  For maximum interoperability, refer to IATA PADIS Code List for data element 9750. Select a code value or enter a value that is bilaterally agreed upon between trading partners.
     * 
     * @return value
     */
    public String getUpgradeMethodCode() {
        return upgradeMethodCode;
    }

    /** 
     * Set the 'UpgradeMethodCode' element value. Upgrade method. Example: AE (BY SSR - SPECIAL SERVICE REQUEST)  For maximum interoperability, refer to IATA PADIS Code List for data element 9750. Select a code value or enter a value that is bilaterally agreed upon between trading partners.
     * 
     * @param upgradeMethodCode
     */
    public void setUpgradeMethodCode(String upgradeMethodCode) {
        this.upgradeMethodCode = upgradeMethodCode;
    }

    /** 
     * Get the 'UpgradeNewClassCode' element value. New Cabin Type Code related to the Upgrade Method. As defined by PADIS codeset (e.g. 1, 2, 3, etc.)
     * 
     * @return value
     */
    public String getUpgradeNewClassCode() {
        return upgradeNewClassCode;
    }

    /** 
     * Set the 'UpgradeNewClassCode' element value. New Cabin Type Code related to the Upgrade Method. As defined by PADIS codeset (e.g. 1, 2, 3, etc.)
     * 
     * @param upgradeNewClassCode
     */
    public void setUpgradeNewClassCode(String upgradeNewClassCode) {
        this.upgradeNewClassCode = upgradeNewClassCode;
    }
}
